/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.graph;

import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerRequest;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.DestinationType;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeEnergyStorage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class NetworkGraphScanner {
    private final Set<Pipe> foundPipes = new HashSet<Pipe>();
    private final Set<Pipe> newPipes = new HashSet<Pipe>();
    private final Set<Pipe> removedPipes = new HashSet<Pipe>();
    private final Set<Destination> destinations = new HashSet<Destination>();
    private final Set<Pipe> currentPipes;
    private final ResourceLocation requiredNetworkType;
    private final List<NetworkGraphScannerRequest> allRequests = new ArrayList<NetworkGraphScannerRequest>();
    private final Queue<NetworkGraphScannerRequest> requests = new ArrayDeque<NetworkGraphScannerRequest>();

    public NetworkGraphScanner(Set<Pipe> currentPipes, ResourceLocation requiredNetworkType) {
        this.currentPipes = currentPipes;
        this.removedPipes.addAll(currentPipes);
        this.requiredNetworkType = requiredNetworkType;
    }

    public NetworkGraphScannerResult scanAt(World world, BlockPos pos) {
        NetworkGraphScannerRequest request;
        this.addRequest(new NetworkGraphScannerRequest(world, pos, null, null));
        while ((request = this.requests.poll()) != null) {
            this.singleScanAt(request);
        }
        return new NetworkGraphScannerResult(this.foundPipes, this.newPipes, this.removedPipes, this.destinations, this.allRequests);
    }

    private void singleScanAt(NetworkGraphScannerRequest request) {
        TileEntity tile;
        Pipe connectedPipe;
        Pipe pipe = NetworkManager.get(request.getWorld()).getPipe(request.getPos());
        if (pipe != null) {
            if (!this.requiredNetworkType.equals((Object)pipe.getNetworkType())) {
                return;
            }
            if (this.foundPipes.add(pipe)) {
                if (!this.currentPipes.contains(pipe)) {
                    this.newPipes.add(pipe);
                }
                this.removedPipes.remove(pipe);
                request.setSuccessful(true);
                for (Direction dir : Direction.values()) {
                    this.addRequest(new NetworkGraphScannerRequest(request.getWorld(), request.getPos().func_177972_a(dir), dir, request));
                }
            }
        } else if (request.getParent() != null && !(connectedPipe = NetworkManager.get(request.getWorld()).getPipe(request.getParent().getPos())).getAttachmentManager().hasAttachment(request.getDirection()) && (tile = request.getWorld().func_175625_s(request.getPos())) != null) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, request.getDirection().func_176734_d()).ifPresent(itemHandler -> this.destinations.add(new Destination(DestinationType.ITEM_HANDLER, request.getPos(), request.getDirection(), connectedPipe)));
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, request.getDirection().func_176734_d()).ifPresent(fluidHandler -> this.destinations.add(new Destination(DestinationType.FLUID_HANDLER, request.getPos(), request.getDirection(), connectedPipe)));
            tile.getCapability(CapabilityEnergy.ENERGY, request.getDirection().func_176734_d()).ifPresent(energyStorage -> {
                if (!(energyStorage instanceof EnergyPipeEnergyStorage)) {
                    this.destinations.add(new Destination(DestinationType.ENERGY_STORAGE, request.getPos(), request.getDirection(), connectedPipe));
                }
            });
        }
    }

    private void addRequest(NetworkGraphScannerRequest request) {
        this.requests.add(request);
        this.allRequests.add(request);
    }
}

