/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbbackups;

import com.feed_the_beast.mods.ftbbackups.Backup;
import com.feed_the_beast.mods.ftbbackups.BackupEvent;
import com.feed_the_beast.mods.ftbbackups.BackupStatus;
import com.feed_the_beast.mods.ftbbackups.BackupUtils;
import com.feed_the_beast.mods.ftbbackups.FTBBackups;
import com.feed_the_beast.mods.ftbbackups.FTBBackupsConfig;
import com.feed_the_beast.mods.ftbbackups.net.BackupProgressPacket;
import com.feed_the_beast.mods.ftbbackups.net.FTBBackupsNetHandler;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;

public enum Backups {
    INSTANCE;

    public final List<Backup> backups = new ArrayList<Backup>();
    public File backupsFolder;
    public long nextBackup = -1L;
    public BackupStatus doingBackup = BackupStatus.NONE;
    public boolean printFiles = false;
    public int currentFile = 0;
    public int totalFiles = 0;
    private String currentFileName = "";
    public boolean hadPlayersOnline = false;

    public void init(MinecraftServer server) {
        JsonElement element;
        File oldFile;
        File dataDir = server.func_71238_n();
        this.backupsFolder = FTBBackupsConfig.folder.trim().isEmpty() ? FMLPaths.GAMEDIR.get().resolve("backups").toFile() : new File(FTBBackupsConfig.folder);
        try {
            this.backupsFolder = this.backupsFolder.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doingBackup = BackupStatus.NONE;
        this.backups.clear();
        File file = new File(dataDir, "local/ftbutilities/backups.json");
        if (!file.exists() && (oldFile = new File(this.backupsFolder, "backups.json")).exists()) {
            oldFile.renameTo(file);
        }
        if ((element = BackupUtils.readJson(file)) != null && element.isJsonArray()) {
            try {
                for (JsonElement e : element.getAsJsonArray()) {
                    JsonObject json = e.getAsJsonObject();
                    if (!json.has("size")) {
                        json.addProperty("size", (Number)BackupUtils.getSize(new File(this.backupsFolder, json.get("file").getAsString())));
                    }
                    this.backups.add(new Backup(json));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        FTBBackups.LOGGER.info("Backups folder - " + this.backupsFolder.getAbsolutePath());
        this.nextBackup = System.currentTimeMillis() + FTBBackupsConfig.backupTimer;
    }

    public void tick(MinecraftServer server, long now) {
        if (!(this.nextBackup <= 0L || this.nextBackup > now || FTBBackupsConfig.onlyIfPlayersOnline && !this.hadPlayersOnline && server.func_184103_al().func_181057_v().isEmpty())) {
            this.hadPlayersOnline = false;
            this.run(server, true, (ITextComponent)new StringTextComponent("Server"), "");
        }
        if (this.doingBackup.isDone()) {
            this.doingBackup = BackupStatus.NONE;
            for (ServerWorld world : server.func_212370_w()) {
                if (world == null) continue;
                world.field_73058_d = false;
            }
            if (!FTBBackupsConfig.silent) {
                FTBBackupsNetHandler.MAIN.send(PacketDistributor.ALL.noArg(), (Object)new BackupProgressPacket(0, 0));
            }
        } else if (this.doingBackup.isRunning() && this.printFiles) {
            if (this.currentFile == 0 || this.currentFile == this.totalFiles - 1) {
                FTBBackups.LOGGER.info("[" + this.currentFile + " | " + (int)((double)this.currentFile / (double)this.totalFiles * 100.0) + "%]: " + this.currentFileName);
            }
            if (!FTBBackupsConfig.silent) {
                FTBBackupsNetHandler.MAIN.send(PacketDistributor.ALL.noArg(), (Object)new BackupProgressPacket(this.currentFile, this.totalFiles));
            }
        }
    }

    public void notifyAll(MinecraftServer server, ITextComponent component, boolean error) {
        component = component.func_230532_e_();
        component.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)(error ? TextFormatting.DARK_RED : TextFormatting.LIGHT_PURPLE)));
        FTBBackups.LOGGER.info(component.getString());
        server.func_184103_al().func_232641_a_(component, ChatType.GAME_INFO, Util.field_240973_b_);
    }

    public boolean run(MinecraftServer server, boolean auto, ITextComponent name, String customName) {
        if (this.doingBackup.isRunningOrDone()) {
            return false;
        }
        if (auto && !FTBBackupsConfig.auto) {
            return false;
        }
        this.notifyAll(server, (ITextComponent)new TranslationTextComponent("ftbbackups.lang.start", new Object[]{name}), false);
        this.nextBackup = System.currentTimeMillis() + FTBBackupsConfig.backupTimer;
        for (ServerWorld world : server.func_212370_w()) {
            if (world == null) continue;
            world.field_73058_d = true;
        }
        this.doingBackup = BackupStatus.RUNNING;
        server.func_184103_al().func_72389_g();
        new Thread(() -> {
            try {
                try {
                    this.createBackup(server, customName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.notifyAll(server, (ITextComponent)new TranslationTextComponent("ftbbackups.lang.saving_failed"), true);
                }
            }
            catch (Exception ex) {
                this.notifyAll(server, (ITextComponent)new TranslationTextComponent("ftbbackups.lang.saving_failed"), true);
                ex.printStackTrace();
            }
            this.doingBackup = BackupStatus.DONE;
        }).start();
        return true;
    }

    private void createBackup(MinecraftServer server, String customName) {
        File src = server.func_240776_a_(FolderName.field_237253_i_).toFile();
        try {
            src = src.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Calendar time = Calendar.getInstance();
        boolean success = false;
        StringBuilder out = new StringBuilder();
        if (customName.isEmpty()) {
            this.appendNum(out, time.get(1), '-');
            this.appendNum(out, time.get(2) + 1, '-');
            this.appendNum(out, time.get(5), '-');
            this.appendNum(out, time.get(11), '-');
            this.appendNum(out, time.get(12), '-');
            this.appendNum(out, time.get(13), '\u0000');
        } else {
            out.append(customName);
        }
        Exception error = null;
        long fileSize = 0L;
        try {
            File dstFile;
            LinkedHashMap<File, String> fileMap = new LinkedHashMap<File, String>();
            String mcdir = server.func_71238_n().getCanonicalFile().getAbsolutePath();
            Consumer<File> consumer = file0 -> {
                for (File file : BackupUtils.listTree(file0)) {
                    String s1 = file.getAbsolutePath().replace(mcdir, "");
                    if (s1.startsWith(File.separator)) {
                        s1 = s1.substring(File.separator.length());
                    }
                    fileMap.put(file, "_extra_" + File.separator + s1);
                }
            };
            for (String string : FTBBackupsConfig.extraFiles) {
                consumer.accept(new File(string));
            }
            MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.Pre(consumer));
            for (File file : BackupUtils.listTree(src)) {
                if (file.getName().equals("session.lock") || !file.canRead()) continue;
                String filePath = file.getAbsolutePath();
                fileMap.put(file, src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1));
            }
            for (Map.Entry entry : fileMap.entrySet()) {
                fileSize += BackupUtils.getSize((File)entry.getKey());
            }
            long totalSize = 0L;
            if (!this.backups.isEmpty()) {
                this.backups.sort(null);
                int backupsToKeep = FTBBackupsConfig.backupsToKeep - 1;
                if (backupsToKeep > 0 && this.backups.size() > backupsToKeep) {
                    while (this.backups.size() > backupsToKeep) {
                        Backup backup = this.backups.remove(0);
                        FTBBackups.LOGGER.info("Deleting old backup: " + backup.fileId);
                        BackupUtils.delete(backup.getFile());
                    }
                }
                for (Backup backup : this.backups) {
                    totalSize += backup.size;
                }
                if (fileSize > 0L) {
                    long freeSpace = Math.min(FTBBackupsConfig.maxTotalSize, this.backupsFolder.getFreeSpace());
                    while (totalSize + fileSize > freeSpace && !this.backups.isEmpty()) {
                        Backup backup = this.backups.remove(0);
                        totalSize -= backup.size;
                        FTBBackups.LOGGER.info("Deleting backup to free space: " + backup.fileId);
                        BackupUtils.delete(backup.getFile());
                    }
                }
            }
            this.totalFiles = fileMap.size();
            FTBBackups.LOGGER.info("Backing up " + this.totalFiles + " files...");
            this.printFiles = true;
            if (FTBBackupsConfig.compressionLevel > 0) {
                out.append(".zip");
                dstFile = BackupUtils.newFile(new File(this.backupsFolder, out.toString()));
                long start = System.currentTimeMillis();
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                zos.setLevel(FTBBackupsConfig.compressionLevel);
                byte[] buffer = new byte[FTBBackupsConfig.bufferSize];
                FTBBackups.LOGGER.info("Compressing " + this.totalFiles + " files...");
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        int len;
                        ZipEntry ze = new ZipEntry((String)entry.getValue());
                        this.currentFileName = (String)entry.getValue();
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream((File)entry.getKey());
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    catch (Exception ex) {
                        FTBBackups.LOGGER.error("Failed to read file " + (String)entry.getValue() + ": " + ex);
                    }
                    ++this.currentFile;
                }
                zos.close();
                fileSize = BackupUtils.getSize(dstFile);
                FTBBackups.LOGGER.info("Done compressing in " + BackupUtils.getTimeString(System.currentTimeMillis() - start) + " seconds (" + BackupUtils.getSizeString(fileSize) + ")!");
            } else {
                dstFile = new File(this.backupsFolder, out.toString());
                dstFile.mkdirs();
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        File file = (File)entry.getKey();
                        this.currentFileName = (String)entry.getValue();
                        File dst1 = new File(dstFile, (String)entry.getValue());
                        BackupUtils.copyFile(file, dst1);
                    }
                    catch (Exception ex) {
                        FTBBackups.LOGGER.error("Failed to copy file " + (String)entry.getValue() + ": " + ex);
                    }
                    ++this.currentFile;
                }
            }
            FTBBackups.LOGGER.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
            success = true;
        }
        catch (Exception ex) {
            if (!FTBBackupsConfig.silent) {
                String errorName = ex.getClass().getName();
                this.notifyAll(server, (ITextComponent)new TranslationTextComponent("ftbbackups.lang.fail", new Object[]{errorName}), true);
            }
            ex.printStackTrace();
            error = ex;
        }
        this.printFiles = false;
        Backup backup = new Backup(time.getTimeInMillis(), out.toString().replace('\\', '/'), this.getLastIndex() + 1, success, fileSize);
        this.backups.add(backup);
        MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.Post(backup, error));
        JsonArray array = new JsonArray();
        for (Backup backup1 : this.backups) {
            array.add((JsonElement)backup1.toJsonObject());
        }
        BackupUtils.toJson(new File(server.func_71238_n(), "local/ftbutilities/backups.json"), (JsonElement)array, true);
        if (error == null && !FTBBackupsConfig.silent) {
            TranslationTextComponent component;
            String timeString = BackupUtils.getTimeString(System.currentTimeMillis() - time.getTimeInMillis());
            if (FTBBackupsConfig.displayFileSize) {
                String sizeT;
                long l = 0L;
                for (Backup backup1 : this.backups) {
                    l += backup1.size;
                }
                String sizeB = BackupUtils.getSizeString(fileSize);
                String sizeString = sizeB.equals(sizeT = BackupUtils.getSizeString(l)) ? sizeB : sizeB + " | " + sizeT;
                component = new TranslationTextComponent("ftbbackups.lang.end_2", new Object[]{timeString, sizeString});
            } else {
                component = new TranslationTextComponent("ftbbackups.lang.end_1", new Object[]{timeString});
            }
            component.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.LIGHT_PURPLE));
            server.func_184103_al().func_232641_a_((ITextComponent)component, ChatType.CHAT, Util.field_240973_b_);
        }
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    private int getLastIndex() {
        int i = 0;
        for (Backup b : this.backups) {
            i = Math.max(i, b.index);
        }
        return i;
    }
}

