/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogethergui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DropdownButton<E extends IDropdownOption>
extends Button {
    public boolean dropdownOpen;
    private E selected;
    private List<E> possibleVals;
    private ITextComponent baseButtonText;
    private final boolean dynamic;
    private final boolean drawHeader;
    public boolean wasJustClosed = false;
    private Button.IPressable ourOnPress;
    Minecraft minecraft = Minecraft.func_71410_x();
    public boolean flipped = false;

    public DropdownButton(int x, int y, int widthIn, int heightIn, ITextComponent buttonText, E def, boolean dynamic, Button.IPressable onPress, boolean drawHeader) {
        super(x, y, widthIn, heightIn, buttonText, e -> {});
        this.ourOnPress = onPress;
        this.selected = def;
        this.possibleVals = def.getPossibleVals();
        this.baseButtonText = buttonText;
        this.dynamic = dynamic;
        this.drawHeader = drawHeader;
    }

    public DropdownButton(int x, int y, int widthIn, int heightIn, ITextComponent buttonText, E def, boolean dynamic, Button.IPressable onPress) {
        this(x, y, widthIn, heightIn, buttonText, def, dynamic, onPress, true);
    }

    public DropdownButton(int x, int y, ITextComponent buttonText, E def, boolean dynamic, Button.IPressable onPress) {
        this(x, y, 200, 20, buttonText, def, dynamic, onPress);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            int drawY = this.field_230691_m_;
            FontRenderer fontrenderer = this.minecraft.field_71466_p;
            this.minecraft.func_110434_K().func_110577_a(field_230687_i_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= drawY && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < drawY + this.field_230689_k_;
            int i = this.getHoverState(this.field_230692_n_);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (this.drawHeader) {
                this.func_238474_b_(matrixStack, this.field_230690_l_, drawY, 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
                this.func_238474_b_(matrixStack, this.field_230690_l_ + this.field_230688_j_ / 2, drawY, 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
                int j = 0xE0E0E0;
                if (!this.field_230693_o_) {
                    j = 0xA0A0A0;
                } else if (this.func_230449_g_()) {
                    j = 0xFFFFA0;
                }
                DropdownButton.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)fontrenderer, (ITextComponent)this.baseButtonText, (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)j);
            }
            if (this.dropdownOpen) {
                ++drawY;
                int yOffset = this.field_230689_k_ - 2;
                if (this.flipped) {
                    yOffset = -yOffset;
                    --drawY;
                }
                int possibleValsSize = this.possibleVals.size();
                for (int j = 0; j < possibleValsSize; ++j) {
                    IDropdownOption e = (IDropdownOption)this.possibleVals.get(j);
                    boolean ourHovered = mouseX >= this.field_230690_l_ && mouseY >= (drawY += yOffset) && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < drawY + this.field_230689_k_ - 2;
                    int subHovered = ourHovered ? 2 : 0;
                    this.minecraft.func_110434_K().func_110577_a(field_230687_i_);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_238474_b_(matrixStack, this.field_230690_l_, drawY, 0, 46 + subHovered * 20 + 1, this.field_230688_j_ / 2, this.field_230689_k_ - 1);
                    this.func_238474_b_(matrixStack, this.field_230690_l_ + this.field_230688_j_ / 2, drawY, 200 - this.field_230688_j_ / 2, 46 + subHovered * 20 + 1, this.field_230688_j_ / 2, this.field_230689_k_ - 1);
                    String name = I18n.func_135052_a((String)e.getTranslate((IDropdownOption)this.selected, true), (Object[])new Object[0]);
                    int textColour = 0xE0E0E0;
                    DropdownButton.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fontrenderer, (String)name, (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(drawY + (this.field_230689_k_ - 10) / 2), (int)textColour);
                }
            }
        }
    }

    protected int getHoverState(boolean mouseOver) {
        return mouseOver ? 2 : (this.field_230693_o_ ? (this.dropdownOpen ? 2 : 1) : 0);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean pressed = super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.dropdownOpen) {
            if (this.drawHeader && pressed) {
                this.close();
                return false;
            }
            E clickedElement = this.getClickedElement(p_mouseClicked_1_, p_mouseClicked_3_);
            if (clickedElement != null) {
                this.setSelected(clickedElement);
                try {
                    this.ourOnPress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed && this.drawHeader) {
            this.dropdownOpen = true;
            if (this.dynamic) {
                this.selected.updateDynamic();
                this.possibleVals = this.selected.getPossibleVals();
            }
        }
        return false;
    }

    public void ourOnPress() {
        this.ourOnPress.onPress((Button)this);
    }

    public void func_230930_b_() {
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        try {
            this.selected = selected;
            this.updateDisplayString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDisplayString() {
        this.baseButtonText = new TranslationTextComponent(I18n.func_135052_a((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[0]), new Object[]{this.baseButtonText});
    }

    private E getClickedElement(double mouseX, double mouseY) {
        IDropdownOption clickedElement = null;
        int y = this.field_230691_m_ + 1;
        int yOffset = this.field_230689_k_ - 2;
        if (this.flipped) {
            yOffset = -yOffset;
            --y;
        }
        for (IDropdownOption e : this.possibleVals) {
            y += yOffset;
            if (!(mouseX >= (double)this.field_230690_l_) || !(mouseY >= (double)y) || !(mouseX < (double)(this.field_230690_l_ + this.field_230688_j_)) || !(mouseY < (double)(y + this.field_230689_k_ - 2))) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public List<E> getPossibleVals() {
        return this.possibleVals;
    }

    public static interface IDropdownOption {
        public List<IDropdownOption> getPossibleVals();

        public String getTranslate(IDropdownOption var1, boolean var2);

        default public void updateDynamic() {
        }
    }
}

