/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.AvailableResult;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogethergui.widgets.TextFieldValidate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GeneralServerInfoScreen
extends OrderServerScreen {
    private static final ResourceLocation lockIcon = new ResourceLocation("minetogether", "textures/lock.png");
    private static final Random random = new Random();
    private String message = "Name can not be blank";
    private TextFieldWidget nameField;
    private boolean isAcceptable = false;
    private boolean nameChecked = false;
    private long lastKeyTyped;
    private Screen parent;

    public GeneralServerInfoScreen(int stepId, Order order, Screen parent) {
        super(stepId, order);
        this.parent = parent;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int halfWidth = this.field_230708_k_ / 2;
        int halfHeight = this.field_230709_l_ / 2;
        int checkboxWidth = this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"minetogether.screen.generalinfo.pregen", (Object[])new Object[0])) + 13;
        this.nameField = new TextFieldValidate(this.field_230712_o_, halfWidth - 100, halfHeight - 50, 200, 20, "([A-Za-z0-9]*)", "");
        this.func_230481_d_((IGuiEventListener)this.nameField);
        this.func_230480_a_((Widget)new CheckboxButton(halfWidth - checkboxWidth / 2, halfHeight - 8, 20, 20, (ITextComponent)new TranslationTextComponent("minetogether.screen.generalinfo.pregen"), this.order.pregen));
        this.nameField.func_146203_f(16);
        this.nameField.func_146180_a(this.order.name.isEmpty() ? GeneralServerInfoScreen.getDefaultName() : this.order.name);
        this.order.name = this.nameField.func_146179_b().trim();
        this.addButtons();
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.func_231165_f_(1);
        GeneralServerInfoScreen.func_238467_a_((MatrixStack)poseStack, (int)0, (int)(this.field_230709_l_ - 20), (int)this.field_230708_k_, (int)20, (int)-1728053248);
        GeneralServerInfoScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.info.server_name", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 65), (int)-1);
        this.field_230706_i_.func_110434_K().func_110577_a(lockIcon);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GeneralServerInfoScreen.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230708_k_ / 2 - 8), (int)(this.field_230709_l_ / 2 + 40), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        int strStart = 61;
        GeneralServerInfoScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("minetogether.screen.generalinfo.secure.line1"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + strStart), (int)0xFFFFFF);
        GeneralServerInfoScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("minetogether.screen.generalinfo.secure.line2"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + strStart + 10), (int)0xFFFFFF);
        GeneralServerInfoScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("minetogether.screen.generalinfo.secure.line3"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + strStart + 20), (int)0xFFFFFF);
        this.nameField.func_230430_a_(poseStack, i, j, f);
        int colour = this.nameChecked && this.isAcceptable ? 65280 : 0xFF0000;
        GeneralServerInfoScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)this.message, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 26), (int)colour);
        super.func_230430_a_(poseStack, i, j, f);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.validateName();
    }

    public void validateName() {
        String nameToCheck = this.nameField.func_146179_b().trim();
        boolean isEmpty = nameToCheck.isEmpty();
        if (this.lastKeyTyped + 400L < System.currentTimeMillis() && !this.nameChecked) {
            this.nameChecked = true;
            if (isEmpty) {
                this.message = "Name cannot be blank";
                this.isAcceptable = false;
            } else {
                CompletableFuture.runAsync(() -> {
                    AvailableResult result = ServerOrderCallbacks.getNameAvailable(nameToCheck);
                    this.isAcceptable = result.getSuccess();
                    this.message = result.getMessage();
                });
            }
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        String nameFieldOldValue = this.nameField.func_146179_b();
        if (!this.nameField.func_231042_a_(typedChar, keyCode)) {
            super.func_231042_a_(typedChar, keyCode);
        } else if (!nameFieldOldValue.equals(this.nameField.func_146179_b())) {
            this.nameChecked = false;
            this.message = "Name not yet checked";
            this.order.name = this.nameField.func_146179_b().trim();
            this.lastKeyTyped = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static String getDefaultName() {
        String[] nm1 = new String[]{"amber", "angel", "spirit", "basin", "lagoon", "basin", "arrow", "autumn", "bare", "bay", "beach", "bear", "bell", "black", "bleak", "blind", "bone", "boulder", "bridge", "brine", "brittle", "bronze", "castle", "cave", "chill", "clay", "clear", "cliff", "cloud", "cold", "crag", "crow", "crystal", "curse", "dark", "dawn", "dead", "deep", "deer", "demon", "dew", "dim", "dire", "dirt", "dog", "dragon", "dry", "dusk", "dust", "eagle", "earth", "east", "ebon", "edge", "elder", "ember", "ever", "fair", "fall", "false", "far", "fay", "fear", "flame", "flat", "frey", "frost", "ghost", "glimmer", "gloom", "gold", "grass", "gray", "green", "grim", "grime", "hazel", "heart", "high", "hollow", "honey", "hound", "ice", "iron", "kil", "knight", "lake", "last", "light", "lime", "little", "lost", "mad", "mage", "maple", "mid", "might", "mill", "mist", "moon", "moss", "mud", "mute", "myth", "never", "new", "night", "north", "oaken", "ocean", "old", "ox", "pearl", "pine", "pond", "pure", "quick", "rage", "raven", "red", "rime", "river", "rock", "rogue", "rose", "rust", "salt", "sand", "scorch", "shade", "shadow", "shimmer", "shroud", "silent", "silk", "silver", "sleek", "sleet", "sly", "small", "smooth", "snake", "snow", "south", "spring", "stag", "star", "steam", "steel", "steep", "still", "stone", "storm", "summer", "sun", "swamp", "swan", "swift", "thorn", "timber", "trade", "west", "whale", "whit", "white", "wild", "wilde", "wind", "winter", "wolf"};
        String[] nm2 = new String[]{"acre", "band", "barrow", "bay", "bell", "born", "borough", "bourne", "breach", "break", "brook", "burgh", "burn", "bury", "cairn", "call", "chill", "cliff", "coast", "crest", "cross", "dale", "denn", "drift", "fair", "fall", "falls", "fell", "field", "ford", "forest", "fort", "front", "frost", "garde", "gate", "glen", "grasp", "grave", "grove", "guard", "gulch", "gulf", "hall", "hallow", "ham", "hand", "harbor", "haven", "helm", "hill", "hold", "holde", "hollow", "horn", "host", "keep", "land", "light", "maw", "meadow", "mere", "mire", "mond", "moor", "more", "mount", "mouth", "pass", "peak", "point", "pond", "port", "post", "reach", "rest", "rock", "run", "scar", "shade", "shear", "shell", "shield", "shore", "shire", "side", "spell", "spire", "stall", "wich", "minster", "star", "storm", "strand", "summit", "tide", "town", "vale", "valley", "vault", "vein", "view", "ville", "wall", "wallow", "ward", "watch", "water", "well", "wharf", "wick", "wind", "wood", "yard"};
        int rnd = random.nextInt(nm1.length);
        int rnd2 = random.nextInt(nm2.length);
        while (nm1[rnd] == nm2[rnd2]) {
            rnd2 = random.nextInt(nm2.length);
        }
        return nm1[rnd] + nm2[rnd2] + random.nextInt(999);
    }

    public void addButtons() {
    }

    @Override
    public String getStepName() {
        return I18n.func_135052_a((String)"minetogether.order.screen.generalinfo", (Object[])new Object[0]);
    }
}

