/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.multiplayer.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.serverlists.Server;
import net.creeperhost.minetogether.lib.serverlists.ServerListCallbacks;
import net.creeperhost.minetogether.module.multiplayer.data.PublicServerEntry;
import net.creeperhost.minetogether.module.multiplayer.data.ServerDataPublic;
import net.creeperhost.minetogether.module.multiplayer.data.ServerListType;
import net.creeperhost.minetogether.module.multiplayer.data.ServerSortOrder;
import net.creeperhost.minetogether.module.multiplayer.screen.ServerTypeScreen;
import net.creeperhost.minetogether.module.multiplayer.sort.LocationComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.PingComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.PlayerComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.ServerNameComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.UptimeComparator;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.creeperhost.minetogethergui.widgets.DropdownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ServerSelectionList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class JoinMultiplayerScreenPublic
extends MultiplayerScreen {
    private final Screen parent;
    private ServerListType serverListType;
    public ServerSortOrder sortOrder = ServerSortOrder.RANDOM;
    private DropdownButton<ServerSortOrder> dropdownButton;
    private boolean loadingSevers = false;
    private int ticks;
    private Widget editButton;
    private Widget deleteButton;
    private Widget cancelButton;

    public JoinMultiplayerScreenPublic(Screen parent, ServerListType serverListType, ServerSortOrder serverSortOrder) {
        super(parent);
        this.parent = parent;
        this.serverListType = serverListType;
        this.sortOrder = serverSortOrder;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_146803_h.func_231039_at__().clear();
        this.updateServerList();
        this.sort();
        this.addButtons();
    }

    public void updateServerList() {
        List<Server> list;
        this.loadingSevers = true;
        ServerList serverList = new ServerList(Minecraft.func_71410_x());
        if (serverList.func_78856_c() > 0) {
            for (int i = 0; i < serverList.func_78856_c(); ++i) {
                ServerData serverData = serverList.func_78850_a(i);
                serverList.func_217506_a(serverData);
            }
        }
        if ((list = ServerListCallbacks.getServerList(this.serverListType, MineTogetherClient.getUUID(), MineTogether.base64, Config.getInstance().getCurseProjectID())) != null && !list.isEmpty()) {
            for (Server server : list) {
                serverList.func_78849_a((ServerData)new ServerDataPublic(server));
            }
            this.updateServers(serverList);
        }
        this.loadingSevers = false;
    }

    public void updateServers(ServerList serverList) {
        this.field_146803_h.func_231039_at__().clear();
        for (int i = 0; i < serverList.func_78856_c(); ++i) {
            this.field_146803_h.func_231039_at__().add(new PublicServerEntry(this, this.field_146803_h, serverList.func_78850_a(i)));
        }
    }

    public void addButtons() {
        String buttonName = "minetogether.multiplayer.title.prefix." + this.serverListType.name().toLowerCase();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 85, 5, 80, 20, (ITextComponent)new TranslationTextComponent(buttonName), p -> this.field_230706_i_.func_147108_a((Screen)new ServerTypeScreen((Screen)this))));
        this.dropdownButton = new DropdownButton<ServerSortOrder>(this.field_230708_k_ - 165, 5, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.multiplayer.sort"), this.sortOrder, false, p -> {
            if (this.sortOrder != this.dropdownButton.getSelected()) {
                this.sortOrder = this.dropdownButton.getSelected();
                this.sort();
                this.field_230706_i_.func_147108_a((Screen)new JoinMultiplayerScreenPublic(this.parent, this.serverListType, this.sortOrder));
            }
        });
        this.func_230480_a_((Widget)this.dropdownButton);
        try {
            this.dropdownButton.setSelected(this.sortOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editButton = ScreenHelpers.findButton("selectServer.edit", this.field_230710_m_);
        this.deleteButton = ScreenHelpers.findButton("selectServer.delete", this.field_230710_m_);
        this.cancelButton = ScreenHelpers.removeButton("gui.cancel", this.field_230710_m_);
        if (this.cancelButton != null) {
            this.func_230480_a_((Widget)new Button(this.cancelButton.field_230690_l_, this.cancelButton.field_230691_m_, this.cancelButton.func_230998_h_(), this.cancelButton.func_238483_d_(), this.cancelButton.func_230458_i_(), button -> this.field_230706_i_.func_147108_a((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()))));
        }
        ScreenHelpers.findButton((String)"selectServer.add", (List<Widget>)this.field_230710_m_).field_230693_o_ = false;
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 80, this.field_230709_l_ - 52, 75, 20, (ITextComponent)new TranslationTextComponent("selectServer.refresh"), p -> Minecraft.func_71410_x().func_147108_a((Screen)new JoinMultiplayerScreenPublic((Screen)new MainMenuScreen(), this.serverListType, this.sortOrder))));
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(1);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.loadingSevers) {
            ScreenHelpers.loadingSpin(partialTicks, this.ticks, this.field_230708_k_ / 2, this.field_230709_l_ / 2, new ItemStack((IItemProvider)Items.field_151082_bd));
        }
    }

    public void func_214295_b() {
        super.func_214295_b();
        if (this.editButton != null) {
            this.editButton.field_230693_o_ = false;
        }
        if (this.deleteButton != null) {
            this.deleteButton.field_230693_o_ = false;
        }
    }

    public void func_231023_e_() {
        ++this.ticks;
    }

    public void func_146796_h() {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.func_230958_g_();
        if (entry != null && entry instanceof PublicServerEntry) {
            this.join(((PublicServerEntry)entry).getServerData());
            return;
        }
        super.func_146796_h();
    }

    public void join(ServerData serverData) {
        this.field_230706_i_.func_147108_a((Screen)new ConnectingScreen((Screen)this, this.field_230706_i_, serverData));
    }

    public void sort() {
        switch (this.sortOrder) {
            default: {
                Collections.shuffle(this.field_146803_h.func_231039_at__());
                break;
            }
            case PLAYER: {
                Collections.sort(this.field_146803_h.func_231039_at__(), PlayerComparator.INSTANCE);
                break;
            }
            case UPTIME: {
                Collections.sort(this.field_146803_h.func_231039_at__(), UptimeComparator.INSTANCE);
                break;
            }
            case NAME: {
                Collections.sort(this.field_146803_h.func_231039_at__(), ServerNameComparator.INSTANCE);
                break;
            }
            case LOCATION: {
                Collections.sort(this.field_146803_h.func_231039_at__(), LocationComparator.INSTANCE);
                break;
            }
            case PING: {
                Collections.sort(this.field_146803_h.func_231039_at__(), PingComparator.INSTANCE);
            }
        }
    }
}

