/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.multiplayer.data;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.lib.serverlists.EnumFlag;
import net.creeperhost.minetogether.lib.serverlists.Server;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.mixin.MixinSelectionList;
import net.creeperhost.minetogether.module.multiplayer.data.ServerDataPublic;
import net.creeperhost.minetogether.module.multiplayer.screen.JoinMultiplayerScreenPublic;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class PublicServerEntry
extends ServerSelectionList.Entry {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final ServerData serverData;
    private ServerSelectionList serverSelectionList;
    private JoinMultiplayerScreenPublic joinMultiplayerScreen;
    private String lastIconB64;
    private final ResourceLocation iconLocation;
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(MineTogether.logger)).build());
    private final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private final ITextComponent CANT_RESOLVE_TEXT = new TranslationTextComponent("multiplayer.status.cannot_resolve").func_240699_a_(TextFormatting.DARK_RED);
    private final ITextComponent NO_CONNECTION_TOOLTIP = new TranslationTextComponent("multiplayer.status.no_connection");
    private final ITextComponent CANT_CONNECT_TEXT = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.DARK_RED);
    private final ITextComponent PINGING_TOOLTIP = new TranslationTextComponent("multiplayer.status.pinging");
    private final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private long lastClickTime;
    private DynamicTexture icon;
    private ResourceLocation flags = new ResourceLocation("minetogether", "textures/flags/flags.png");

    public PublicServerEntry(JoinMultiplayerScreenPublic joinMultiplayerScreen, ServerSelectionList serverSelectionList, ServerData serverData) {
        this.serverData = serverData;
        this.joinMultiplayerScreen = joinMultiplayerScreen;
        this.serverSelectionList = serverSelectionList;
        this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars(serverData.field_78845_b) + "/icon");
        this.icon = (DynamicTexture)this.minecraft.func_110434_K().func_229267_b_(this.iconLocation);
    }

    public void func_230432_a_(MatrixStack poseStack, int i, int j, int k, int l, int m3, int n, int o, boolean bl, float f) {
        List list5;
        TranslationTextComponent component5;
        int z;
        if (!this.serverData.field_78841_f) {
            this.serverData.field_78841_f = true;
            this.serverData.field_78844_e = -2L;
            this.serverData.field_78843_d = StringTextComponent.field_240750_d_;
            this.serverData.field_78846_c = StringTextComponent.field_240750_d_;
            THREAD_POOL.submit(() -> {
                try {
                    this.joinMultiplayerScreen.func_146789_i().func_147224_a(this.serverData, () -> this.minecraft.execute(this::updateServerList));
                }
                catch (UnknownHostException var2) {
                    this.serverData.field_78844_e = -1L;
                    this.serverData.field_78843_d = this.CANT_RESOLVE_TEXT;
                }
                catch (Exception var3) {
                    this.serverData.field_78844_e = -1L;
                    this.serverData.field_78843_d = this.CANT_CONNECT_TEXT;
                }
            });
        }
        boolean bl2 = false;
        this.minecraft.field_71466_p.func_238421_b_(poseStack, this.serverData.field_78847_a, (float)(k + 32 + 3), (float)(j + 1), 0xFFFFFF);
        List list = this.minecraft.field_71466_p.func_238425_b_((ITextProperties)this.serverData.field_78843_d, l - 32 - 2);
        for (int p = 0; p < Math.min(list.size(), 2); ++p) {
            FontRenderer var10000 = this.minecraft.field_71466_p;
            IReorderingProcessor var10002 = (IReorderingProcessor)list.get(p);
            float var10003 = k + 32 + 3;
            int var10004 = j + 12;
            this.minecraft.field_71466_p.getClass();
            var10000.func_238422_b_(poseStack, var10002, var10003, (float)(var10004 + 9 * p), 0x808080);
        }
        ITextComponent component = bl2 ? this.serverData.field_82822_g.func_230532_e_().func_240699_a_(TextFormatting.RED) : this.serverData.field_78846_c;
        int q = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)component);
        this.minecraft.field_71466_p.func_243248_b(poseStack, component, (float)(k + l - q - 15 - 2), (float)(j + 1), 0x808080);
        int r = 0;
        if (bl2) {
            z = 5;
            component5 = new TranslationTextComponent("");
            list5 = this.serverData.field_147412_i;
        } else if (this.serverData.field_78841_f && this.serverData.field_78844_e != -2L) {
            z = this.serverData.field_78844_e < 0L ? 5 : (this.serverData.field_78844_e < 150L ? 0 : (this.serverData.field_78844_e < 300L ? 1 : (this.serverData.field_78844_e < 600L ? 2 : (this.serverData.field_78844_e < 1000L ? 3 : 4))));
            if (this.serverData.field_78844_e < 0L) {
                component5 = this.NO_CONNECTION_TOOLTIP;
                list5 = Collections.emptyList();
            } else {
                component5 = new TranslationTextComponent("multiplayer.status.ping", new Object[]{this.serverData.field_78844_e});
                list5 = this.serverData.field_147412_i;
            }
        } else {
            r = 1;
            z = (int)(Util.func_211177_b() / 100L + (long)(i * 2) & 7L);
            if (z > 4) {
                z = 8 - z;
            }
            component5 = this.PINGING_TOOLTIP;
            list5 = Collections.emptyList();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(k + l - 15), (int)j, (float)(r * 10), (float)(176 + z * 8), (int)10, (int)8, (int)256, (int)256);
        String string = this.serverData.func_147409_e();
        if (!Objects.equals(string, this.lastIconB64)) {
            if (this.uploadServerIcon(string)) {
                this.lastIconB64 = string;
            } else {
                this.serverData.func_147407_a((String)null);
                this.updateServerList();
            }
        }
        if (this.icon != null) {
            this.drawIcon(poseStack, k, j, this.iconLocation);
        } else {
            this.drawIcon(poseStack, k, j, this.ICON_MISSING);
        }
        int aa = n - k;
        int ab = o - j;
        if (aa >= l - 15 && aa <= l - 5 && ab >= 0 && ab <= 8) {
            this.joinMultiplayerScreen.func_238854_b_(Collections.singletonList(component5));
        } else if (aa >= l - q - 15 - 2 && aa <= l - 15 - 2 && ab >= 0 && ab <= 8) {
            this.joinMultiplayerScreen.func_238854_b_(list5);
        }
        if (this.minecraft.field_71474_y.field_85185_A || bl) {
            this.minecraft.func_110434_K().func_110577_a(this.ICON_OVERLAY_LOCATION);
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)k, (int)j, (int)(k + 32), (int)(j + 32), (int)-1601138544);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ac = n - k;
            int ad = o - j;
            if (this.canJoin()) {
                if (ac < 32 && ac > 16) {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)k, (int)j, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                } else {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)k, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                }
            }
            if (i < this.joinMultiplayerScreen.func_146795_p().func_78856_c() - 1) {
                if (ac < 16 && ad > 16) {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)k, (int)j, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                } else {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)k, (int)j, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }
        if (this.getServerData() != null) {
            Server server = this.getServerData().server;
            EnumFlag flag = server.flag;
            String applicationURL = server.applicationURL;
            if (flag != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.flags);
                int flagWidth = 16;
                int flagHeight = flag.height / (flag.width / flagWidth);
                ScreenHelpers.drawScaledCustomSizeModalRect(k + l - 5 - flagWidth, j + 30 - flagHeight, flag.x, flag.y, flag.width, flag.height, flagWidth, flagHeight, 512.0f, 512.0f);
                if (n >= k + l - 5 - flagWidth && n <= k + l - 5 && o >= j - 10 - flagHeight && o <= j - flagHeight + flagHeight) {
                    ArrayList<TranslationTextComponent> tooltipList = new ArrayList<TranslationTextComponent>();
                    String countryName = ServerOrderCallbacks.getCountries().get(flag.name());
                    if (countryName == null) {
                        countryName = flag.name();
                    }
                    tooltipList.add(new TranslationTextComponent(countryName));
                    this.joinMultiplayerScreen.func_238854_b_(tooltipList);
                }
            }
        }
    }

    private boolean uploadServerIcon(@Nullable String string) {
        if (string == null) {
            this.minecraft.func_110434_K().func_147645_c(this.iconLocation);
            if (this.icon != null && this.icon.func_195414_e() != null) {
                this.icon.func_195414_e().close();
            }
            this.icon = null;
        } else {
            try {
                NativeImage nativeImage = NativeImage.func_216511_b((String)string);
                Validate.validState((nativeImage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                if (this.icon == null) {
                    this.icon = new DynamicTexture(nativeImage);
                } else {
                    this.icon.func_195415_a(nativeImage);
                    this.icon.func_110564_a();
                }
                this.minecraft.func_110434_K().func_229263_a_(this.iconLocation, (Texture)this.icon);
            }
            catch (Throwable var3) {
                MineTogether.logger.error("Invalid icon for server {} ({})", (Object)this.serverData.field_78847_a, (Object)this.serverData.field_78845_b, (Object)var3);
                return false;
            }
        }
        return true;
    }

    private boolean canJoin() {
        return true;
    }

    public void updateServerList() {
        this.joinMultiplayerScreen.func_146795_p().func_78855_b();
    }

    protected void drawIcon(MatrixStack poseStack, int i, int j, ResourceLocation resourceLocation) {
        this.minecraft.func_110434_K().func_110577_a(resourceLocation);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        RenderSystem.disableBlend();
    }

    public ServerDataPublic getServerData() {
        if (this.serverData instanceof ServerDataPublic) {
            return (ServerDataPublic)this.serverData;
        }
        return null;
    }

    public boolean func_231044_a_(double d, double e, int i) {
        double f = d - (double)this.serverSelectionList.func_230968_n_();
        double g2 = e - (double)((MixinSelectionList)this.serverSelectionList).invokeRowTop(this.serverSelectionList.func_231039_at__().indexOf((Object)this));
        if (f <= 32.0 && f < 32.0 && f > 16.0 && this.canJoin()) {
            this.joinMultiplayerScreen.func_214287_a(this);
            this.joinMultiplayerScreen.func_146796_h();
            return true;
        }
        this.joinMultiplayerScreen.func_214287_a(this);
        if (Util.func_211177_b() - this.lastClickTime < 250L) {
            this.joinMultiplayerScreen.func_146796_h();
        }
        this.lastClickTime = Util.func_211177_b();
        return false;
    }
}

