/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.connect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.FriendDetector;
import net.creeperhost.minetogether.module.connect.LanServerInfoConnect;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.network.LanServerDetector;
import net.minecraft.client.network.LanServerInfo;

public class FriendsServerList
extends LanServerDetector.LanServerList {
    private final LanServerDetector.LanServerList wrapped;
    public static ScheduledExecutorService detectorExecutor;
    private boolean oursWasUpdated;
    private final List<LanServerInfo> ourLanServers = new ArrayList<LanServerInfo>();
    final MultiplayerScreen owner;
    FriendDetector detector;
    private final List<FriendDetector.PendingFriend> pendingFriendServers = new ArrayList<FriendDetector.PendingFriend>();
    private long lastCheckTime = System.currentTimeMillis() - 1000L;

    public FriendsServerList(MultiplayerScreen owner, LanServerDetector.LanServerList wrapped) {
        this.wrapped = wrapped;
        this.owner = owner;
        this.oursWasUpdated = true;
        if (ConnectHelper.isEnabled) {
            detectorExecutor = Executors.newSingleThreadScheduledExecutor();
            detectorExecutor.scheduleAtFixedRate(new FriendDetector(this), 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public synchronized void addOurServer(FriendDetector.PendingFriend friend) {
        LanServerInfoConnect lanServerInfo = new LanServerInfoConnect(friend);
        this.ourLanServers.add(lanServerInfo);
        this.oursWasUpdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPendingServer(FriendDetector.PendingFriend data) {
        List<FriendDetector.PendingFriend> list = this.pendingFriendServers;
        synchronized (list) {
            for (FriendDetector.PendingFriend server : this.pendingFriendServers) {
                if (!data.getAddress().equals(server.getAddress())) continue;
                return;
            }
            List<LanServerInfo> list2 = this.ourLanServers;
            synchronized (list2) {
                for (LanServerInfo server : this.ourLanServers) {
                    if (!data.getAddress().equals(server.func_77488_b())) continue;
                    return;
                }
            }
            this.pendingFriendServers.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean func_77553_a() {
        long curTime = System.currentTimeMillis();
        if (this.lastCheckTime + 1000L <= curTime) {
            ArrayList<FriendDetector.PendingFriend> removingServers = new ArrayList<FriendDetector.PendingFriend>();
            List<FriendDetector.PendingFriend> list = this.pendingFriendServers;
            synchronized (list) {
                for (FriendDetector.PendingFriend friendServer : this.pendingFriendServers) {
                    removingServers.add(friendServer);
                    this.addOurServer(friendServer);
                    this.oursWasUpdated = true;
                }
                this.pendingFriendServers.removeAll(removingServers);
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return this.oursWasUpdated || this.wrapped.func_77553_a();
    }

    public synchronized void func_77551_a(String pingResponse, InetAddress ipAddress) {
        this.wrapped.func_77551_a(pingResponse, ipAddress);
    }

    public synchronized void func_77552_b() {
        this.wrapped.func_77552_b();
        this.oursWasUpdated = false;
    }

    public synchronized List<LanServerInfo> func_77554_c() {
        return Collections.unmodifiableList(Lists.newArrayList(Iterables.concat(this.wrapped.func_77554_c(), this.ourLanServers)));
    }

    public void removed() {
        if (detectorExecutor != null) {
            detectorExecutor.shutdown();
        }
    }
}

