/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.creeperhost.minetogether.module.chat.screen.widgets.GuiButtonChat;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiButtonPair
extends Button {
    GuiButtonChat button1;
    GuiButtonChat button2;
    GuiButtonChat button3;
    ArrayList<GuiButtonChat> buttons = new ArrayList();
    public int activeButton;
    private final boolean stack;
    private final boolean swapOnClick;
    private final boolean vertical;

    public GuiButtonPair(int x, int y, int widthIn, int heightIn, int state, boolean stack, boolean swapOnClick, boolean vertical, Button.IPressable onPress, String ... buttonTexts) {
        super(x, y, widthIn, heightIn, (ITextComponent)new TranslationTextComponent(buttonTexts[0]), onPress);
        this.activeButton = state;
        this.swapOnClick = swapOnClick;
        this.stack = stack;
        this.vertical = vertical;
        for (String button : buttonTexts) {
            this.buttons.add(new GuiButtonChat(0, 0, 0, heightIn, button, onPress));
        }
        this.buttons.get(this.activeButton).setActive(true);
        this.button1 = this.buttons.get(0);
        this.button2 = this.buttons.get(1);
        this.setButtonDetails();
    }

    public ArrayList<GuiButtonChat> getButtons() {
        return this.buttons;
    }

    private void setButtonDetails() {
        int buttWidth = this.field_230688_j_ / this.buttons.size();
        int baseX = this.field_230690_l_;
        int baseY = this.field_230691_m_;
        int buttonCount = this.buttons.size();
        for (int buttonNum = 0; buttonNum < buttonCount; ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            int visibleNum = buttonNum;
            if (this.swapOnClick) {
                visibleNum = (buttonNum + buttonCount - this.activeButton) % buttonCount;
            }
            button.func_230991_b_(buttWidth);
            if (this.stack) {
                button.field_230690_l_ = baseX;
                button.field_230691_m_ = baseY + visibleNum * this.field_230689_k_;
                continue;
            }
            button.field_230690_l_ = baseX + visibleNum * buttWidth;
            button.field_230691_m_ = baseY;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_191745_2_, int p_191745_3_, float p_191745_4_) {
        double mouseX = p_191745_2_;
        double mouseY = p_191745_3_;
        float scale = 0.75f;
        float xTranslate = -this.buttons.get((int)0).field_230690_l_;
        float yTranslate = -this.buttons.get((int)0).field_230691_m_;
        int buttonCount = this.buttons.size();
        int[] cachedX = new int[buttonCount];
        int[] cachedY = new int[buttonCount];
        if (this.vertical) {
            float tempTranslateY;
            float tempTranslateX;
            double xDiff = mouseX - (double)this.button1.field_230690_l_;
            double yDiff = mouseY - (double)this.button1.field_230691_m_;
            mouseX = yDiff / (double)scale;
            mouseY = xDiff / (double)scale + (double)this.field_230689_k_;
            int buttWidth = this.field_230688_j_ / this.buttons.size();
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button = this.buttons.get(buttNum);
                int visibleNum = buttNum;
                if (this.swapOnClick) {
                    visibleNum = (buttNum + buttonCount - this.activeButton) % buttonCount;
                }
                cachedX[buttNum] = button.field_230690_l_;
                cachedY[buttNum] = button.field_230691_m_;
                button.field_230690_l_ = buttWidth * visibleNum;
                button.field_230691_m_ = 0;
            }
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            RenderSystem.pushMatrix();
            if (this.stack) {
                tempTranslateX = -xTranslate + (float)(this.field_230689_k_ * 2);
                tempTranslateY = -yTranslate - (float)this.field_230688_j_;
            } else {
                tempTranslateX = -xTranslate * (1.0f / scale);
                tempTranslateY = -yTranslate * (1.0f / scale);
            }
            RenderSystem.translated((double)tempTranslateX, (double)(tempTranslateY -= scale), (double)0.0);
            RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        for (GuiButtonChat button : this.buttons) {
            button.func_230430_a_(matrixStack, (int)mouseX, (int)mouseY, p_191745_4_);
        }
        if (this.vertical) {
            RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            RenderSystem.popMatrix();
            RenderSystem.scalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button;
                button = this.buttons.get(buttNum);
                button.field_230690_l_ = cachedX[buttNum];
                button.field_230691_m_ = cachedY[buttNum];
            }
        }
    }

    public boolean func_231044_a_(double mouseXIn, double mouseYIn, int p_mouseClicked_5_) {
        double mouseX = mouseXIn;
        double mouseY = mouseYIn;
        if (this.vertical) {
            double xDiff = (mouseX - (double)this.button1.field_230690_l_) / 0.75;
            double yDiff = (mouseY - (double)this.button1.field_230691_m_) / 0.75;
            mouseX = (double)this.button1.field_230690_l_ + yDiff;
            mouseY = (double)this.button1.field_230691_m_ + xDiff + (double)this.field_230689_k_;
        }
        boolean pressed = false;
        for (int buttonNum = 0; buttonNum < this.buttons.size(); ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            if (!button.func_231044_a_(mouseX, mouseY, p_mouseClicked_5_)) continue;
            if (this.activeButton != buttonNum) {
                this.buttons.get(this.activeButton).setActive(false);
            }
            this.activeButton = buttonNum;
            button.setActive(true);
            this.func_230930_b_();
            pressed = true;
            break;
        }
        return pressed;
    }
}

