/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.handler.ToastHandler;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ScrollingChat;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.MutedListScreen;
import net.creeperhost.minetogether.module.chat.screen.listentries.ListEntryFriend;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.creeperhost.minetogethergui.lists.ScreenList;
import net.creeperhost.minetogethergui.widgets.ButtonMultiple;
import net.creeperhost.minetogethergui.widgets.ButtonString;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FriendsListScreen
extends MineTogetherScreen {
    private final Screen parent;
    private ScreenList<ListEntryFriend> list;
    private ScrollingChat chat;
    private TextFieldWidget chatBox;
    private TextFieldWidget searchEntry;
    private int ticks;
    private Profile targetProfile = null;
    private Button removeFriend;
    private Button blockButton;
    private Button partyButton;
    private Button friendCodeButton;
    private Button editButton;
    private Button mutedList;
    public static ArrayList<Profile> removedFriends = new ArrayList();

    public FriendsListScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("minetogether.friendscreen.title"));
        this.parent = parent;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        CompletableFuture.runAsync(FriendUpdateThread::updateFriendsList);
        this.list = new ScreenList(this, this.field_230706_i_, 100, this.field_230709_l_ - 90, 32, this.field_230709_l_ - 55, 28, 100);
        this.list.func_230959_g_(18);
        this.chat = new ScrollingChat(this, this.field_230708_k_ - this.list.func_230949_c_() - 40, this.field_230709_l_ - 90, 32, this.field_230709_l_ - 55, 110, true);
        this.chat.func_230959_g_(this.list.func_244736_r());
        this.chatBox = new TextFieldWidget(this.field_230712_o_, this.list.func_244736_r() + 1, this.field_230709_l_ - 50, this.chat.getWidth() - 2, 20, (ITextComponent)new TranslationTextComponent(""));
        this.chatBox.func_146203_f(256);
        this.searchEntry = new TextFieldWidget(this.field_230712_o_, 19, this.field_230709_l_ - 50, this.list.width - 2, 20, (ITextComponent)new TranslationTextComponent(""));
        this.searchEntry.func_195612_c(I18n.func_135052_a((String)"minetogether.search", (Object[])new Object[0]));
        this.addButtons();
        this.field_230705_e_.add(this.list);
        this.field_230705_e_.add(this.searchEntry);
        this.field_230705_e_.add(this.chatBox);
        this.field_230705_e_.add(this.chat);
        this.refreshFriendsList();
    }

    public void addButtons() {
        this.func_230480_a_((Widget)new Button(5, this.field_230709_l_ - 26, 100, 20, (ITextComponent)new TranslationTextComponent("Cancel"), p -> this.field_230706_i_.func_147108_a(this.parent)));
        this.friendCodeButton = new ButtonString(this.field_230708_k_ - 105, 5, 120, 20, (ITextComponent)new TranslationTextComponent(MineTogetherChat.profile.get().getFriendCode()), p -> {
            this.field_230706_i_.field_195559_v.func_197960_a(MineTogetherChat.profile.get().getFriendCode());
            MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent("Copied to clipboard."), this.field_230708_k_ - 160, 0, 5000, ToastHandler.EnumToastType.DEFAULT, null);
        });
        this.func_230480_a_((Widget)this.friendCodeButton);
        this.removeFriend = new ButtonMultiple(this.field_230708_k_ - 20, 32, 5, Constants.WIDGETS_LOCATION, (ITextComponent)new TranslationTextComponent("minetogether.friendscreen.tooltip.removebutton"), button -> this.removeFriend(this.targetProfile));
        this.func_230480_a_((Widget)this.removeFriend);
        this.blockButton = new ButtonMultiple(this.field_230708_k_ - 20, 52, 6, Constants.WIDGETS_LOCATION, (ITextComponent)new TranslationTextComponent("minetogether.friendscreen.tooltip.block"), button -> ChatModule.muteUser(this.targetProfile.getLongHash()));
        this.func_230480_a_((Widget)this.blockButton);
        this.partyButton = new ButtonMultiple(this.field_230708_k_ - 20, 72, 7, Constants.WIDGETS_LOCATION, (ITextComponent)new TranslationTextComponent("minetogether.friendscreen.tooltip.partytime"), button -> ChatHandler.sendPartyInvite(this.targetProfile.getMediumHash(), MineTogetherChat.profile.get().getMediumHash()));
        this.func_230480_a_((Widget)this.partyButton);
        this.editButton = new ButtonMultiple(this.field_230708_k_ - 20, 92, 8, Constants.WIDGETS_LOCATION, (ITextComponent)new TranslationTextComponent("minetogether.friendscreen.tooltip.editbutton"), button -> this.field_230706_i_.func_147108_a((Screen)new FriendRequestScreen(this, this.field_230706_i_.func_110432_I().func_111285_a(), this.targetProfile, ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), this.targetProfile.getFriendName(), false, true)));
        this.func_230480_a_((Widget)this.editButton);
        this.mutedList = new Button(5, 5, 100, 20, (ITextComponent)new TranslationTextComponent("Muted List"), p -> this.field_230706_i_.func_147108_a((Screen)new MutedListScreen(this)));
        this.func_230480_a_((Widget)this.mutedList);
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.func_231165_f_(1);
        this.list.func_230430_a_(poseStack, i, j, f);
        this.searchEntry.func_230430_a_(poseStack, i, j, f);
        this.chatBox.func_230430_a_(poseStack, i, j, f);
        this.chat.func_230430_a_(poseStack, i, j, f);
        super.func_230430_a_(poseStack, i, j, f);
        FriendsListScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)12, (int)0xFFFFFF);
        if (this.list.func_231039_at__().isEmpty()) {
            FriendsListScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("minetogether.friendslist.empty"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)-1);
        }
        if (this.friendCodeButton != null && this.friendCodeButton.func_230449_g_()) {
            this.func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("minetogether.friendslist.copytoclipboard"), i, j);
        }
    }

    public void func_231023_e_() {
        ++this.ticks;
        if (this.ticks % 600 == 0) {
            this.refreshFriendsList();
        }
        if (this.targetProfile != null) {
            this.partyButton.field_230693_o_ = this.targetProfile.isOnline();
        }
        if (this.list.getCurrSelected() != null && this.targetProfile != null && !this.targetProfile.equals(this.list.getCurrSelected().getProfile())) {
            this.targetProfile = this.list.getCurrSelected().getProfile();
            this.chat.updateLines(this.targetProfile.getMediumHash());
        }
        if (this.targetProfile != null) {
            this.chatBox.func_195612_c(this.targetProfile.isOnline() ? "" : "Friend is offline");
            this.chatBox.func_146184_c(this.targetProfile.isOnline());
            if (ChatHandler.hasNewMessages(this.targetProfile.getMediumHash())) {
                this.chat.updateLines(this.targetProfile.getMediumHash());
                ChatHandler.setMessagesRead(this.targetProfile.getMediumHash());
            }
        }
        this.toggleInteractionButtons(this.list.getCurrSelected() != null);
    }

    public void toggleInteractionButtons(boolean value) {
        this.removeFriend.field_230693_o_ = value;
        this.blockButton.field_230693_o_ = value;
        this.editButton.field_230693_o_ = value;
        if (this.targetProfile == null) {
            this.partyButton.field_230693_o_ = value;
        }
    }

    protected boolean refreshFriendsList() {
        List<Profile> friendsRet = KnownUsers.getFriends();
        if (friendsRet == null) {
            return false;
        }
        ArrayList friends = new ArrayList();
        List onlineFriends = friendsRet.stream().filter(Profile::isOnline).collect(Collectors.toList());
        onlineFriends.sort(NameComparator.INSTANCE);
        List offlineFriends = friendsRet.stream().filter(profile -> !profile.isOnline()).collect(Collectors.toList());
        offlineFriends.sort(NameComparator.INSTANCE);
        friends.addAll(onlineFriends);
        friends.addAll(offlineFriends);
        this.list.clearList();
        if (friends != null) {
            for (Profile friendProfile : friends) {
                ListEntryFriend friendEntry = new ListEntryFriend(this, this.list, friendProfile);
                if (this.searchEntry != null && !this.searchEntry.func_146179_b().isEmpty()) {
                    String s2 = this.searchEntry.func_146179_b();
                    if (friendProfile.friendName.toLowerCase().contains(s2.toLowerCase()) && !removedFriends.contains(friendProfile)) {
                        this.list.add(friendEntry);
                    }
                } else if (!removedFriends.contains(friendProfile)) {
                    this.list.add(friendEntry);
                }
                if (this.targetProfile == null || !friendProfile.getFriendName().equals(this.targetProfile.getFriendName())) continue;
                this.list.func_241215_a_(friendEntry);
            }
            ArrayList<Profile> removedCopy = new ArrayList<Profile>(removedFriends);
            for (Profile removed : removedCopy) {
                boolean isInList = false;
                for (Profile friend : friends) {
                    if (!friend.friendCode.equalsIgnoreCase(removed.friendCode)) continue;
                    isInList = true;
                    break;
                }
                if (isInList) continue;
                removedFriends.remove(removed);
            }
        }
        return true;
    }

    public void removeFriend(Profile profile) {
        ConfirmScreen confirmScreen = new ConfirmScreen(t -> {
            if (t) {
                CompletableFuture.runAsync(() -> {
                    removedFriends.add(profile);
                    this.refreshFriendsList();
                    if (!ChatCallbacks.removeFriend(profile.getFriendCode(), MineTogetherClient.getPlayerHash())) {
                        profile.setFriend(false);
                        this.refreshFriendsList();
                    }
                });
            }
            this.field_230706_i_.func_147108_a((Screen)new FriendsListScreen(this.parent));
        }, (ITextComponent)new TranslationTextComponent("minetogether.removefriend.sure1"), (ITextComponent)new TranslationTextComponent("minetogether.removefriend.sure2"));
        this.field_230706_i_.func_147108_a((Screen)confirmScreen);
    }

    public boolean func_231042_a_(char c, int i) {
        if (this.searchEntry.func_230999_j_()) {
            boolean flag = this.searchEntry.func_231042_a_(c, i);
            this.refreshFriendsList();
            return flag;
        }
        if (this.chatBox.func_230999_j_()) {
            return this.chatBox.func_231042_a_(c, i);
        }
        return super.func_231042_a_(c, i);
    }

    public boolean func_231046_a_(int i, int j, int k) {
        if (this.searchEntry.func_230999_j_()) {
            this.searchEntry.func_195612_c("");
            boolean flag = this.searchEntry.func_231046_a_(i, j, k);
            this.refreshFriendsList();
            return flag;
        }
        if (this.targetProfile != null && this.chatBox.func_230999_j_()) {
            if (!(i != 257 && i != 335 || this.chatBox.func_146179_b().trim().isEmpty())) {
                ChatHandler.sendMessage(this.targetProfile.getMediumHash(), ChatFormatter.getStringForSending(this.chatBox.func_146179_b()));
                this.chatBox.func_146180_a("");
            }
            return this.chatBox.func_231046_a_(i, j, k);
        }
        return super.func_231046_a_(i, j, k);
    }

    public boolean func_231044_a_(double d, double e, int i) {
        return super.func_231044_a_(d, e, i);
    }

    public boolean func_231048_c_(double d, double e, int i) {
        if (this.list.func_231047_b_(d, e) && this.list.getCurrSelected() != null) {
            boolean flag;
            if (this.list.getCurrSelected() == null) {
                return super.func_231048_c_(d, e, i);
            }
            boolean bl = flag = this.targetProfile == null || !this.targetProfile.equals(this.list.getCurrSelected().getProfile());
            if (flag) {
                Profile profile = this.list.getCurrSelected().getProfile();
                if (profile != null && profile.isFriend()) {
                    this.targetProfile = profile;
                    this.chat.updateLines(profile.getMediumHash());
                }
                return flag;
            }
        }
        return super.func_231048_c_(d, e, i);
    }

    public static class NameComparator
    implements Comparator<Profile> {
        public static final NameComparator INSTANCE = new NameComparator();

        @Override
        public int compare(Profile profile1, Profile profile2) {
            String str1 = profile1.friendName;
            String str2 = profile2.friendName;
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    }
}

