/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.handler.ToastHandler;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.IChatListener;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ChatListener
implements IChatListener {
    public static ChatListener INSTANCE = new ChatListener();

    @Override
    public void onPartyInvite(Profile profile) {
        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent("New party invite from " + profile.getFriendName()), 5000, ToastHandler.EnumToastType.DEFAULT, () -> {
            Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
            ConfirmScreen confirmScreen = new ConfirmScreen(accepted -> {
                if (accepted) {
                    ChatHandler.acceptPartyInvite(profile);
                }
                MineTogetherClient.toastHandler.clearToast(true);
                Minecraft.func_71410_x().func_147108_a(currentScreen);
            }, (ITextComponent)new TranslationTextComponent("You have been invited to join a private party from " + profile.getFriendName()), (ITextComponent)new TranslationTextComponent("Do you wish to accept the invite?"));
            Minecraft.func_71410_x().func_147108_a((Screen)confirmScreen);
        });
    }

    @Override
    public void onFriendOnline(Profile profile) {
        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent(profile.getFriendName() + " Is now online"), 5000, ToastHandler.EnumToastType.DEFAULT, null);
    }

    @Override
    public void onFriendAccept(String name, String data) {
        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent(name + " Has accepted your friend request"), 5000, ToastHandler.EnumToastType.DEFAULT, null);
        ChatHandler.addMessageToChat(ChatHandler.CHANNEL, "FA:" + name, data);
        Profile profile = KnownUsers.findByNick(name);
        if (profile != null) {
            CompletableFuture.runAsync(() -> ChatCallbacks.addFriend(profile.getFriendCode(), data, MineTogetherClient.getPlayerHash()), MineTogetherChat.otherExecutor);
        }
    }

    @Override
    public void onFriendRequest(String user, String data) {
        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent(user + " Has sent you a friend request"), 5000, ToastHandler.EnumToastType.DEFAULT, null);
        ChatHandler.addMessageToChat(ChatHandler.CHANNEL, "FR:" + user, data);
    }

    @Override
    public String onServerIdRequest() {
        return MineTogetherClient.getServerIDAndVerify();
    }

    @Override
    public void sendMessage(String channel, Message message) {
        ChatModule.sendMessage(channel, ChatFormatter.formatLine(message));
    }

    @Override
    public void setHasNewMessage(boolean value) {
        ChatModule.hasNewMessage = value;
    }

    @Override
    public String getVerifyOutput() {
        return MineTogetherChat.INSTANCE.signature + ":" + MineTogetherClient.getUUID() + ":" + MineTogetherClient.getServerIDAndVerify();
    }
}

