/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.vpn;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.covers1624.quack.util.HashUtils;
import net.creeperhost.minetogether.lib.util.BasicOS;
import net.creeperhost.minetogether.lib.util.FileUtils;
import net.creeperhost.minetogether.lib.util.StreamGobblerLog;
import net.creeperhost.minetogether.lib.util.WebUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogetherConnect {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Supplier<Boolean> enabledFunc;
    private Process vpnProcess;
    private boolean connected;
    private Runnable runConnected;
    private Runnable runDisconnected;
    private String binary = "";
    private final String mthash;
    private final Path mtconnectDir;
    private final String sessionString;

    public MineTogetherConnect(String mthash, Supplier<Boolean> enabledFunc, Path mtconnectDir, String sessionString) {
        this.enabledFunc = enabledFunc;
        this.mthash = mthash;
        this.mtconnectDir = mtconnectDir;
        this.sessionString = sessionString;
        if (mthash == null || mthash.isEmpty()) {
            LOGGER.info("Tried to initialize MineTogether Connect before storing MineTogether identifier...");
        }
    }

    public boolean isEnabled() {
        return this.mthash != null && !this.mthash.isEmpty() && this.enabledFunc.get() != false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean connect() {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.vpnProcess != null && this.vpnProcess.isAlive()) {
            return false;
        }
        ArrayList<String> executable = new ArrayList<String>();
        switch (BasicOS.CURRENT) {
            case WIN: {
                this.binary = "MineTogetherConnect.exe";
                executable.add(this.mtconnectDir.resolve(this.binary).toAbsolutePath().toString());
                break;
            }
            default: {
                LOGGER.warn("Unsupported operating system {}", (Object)BasicOS.CURRENT);
            }
        }
        if (executable.size() == 0 || this.binary.isEmpty()) {
            return false;
        }
        Path primaryPath = this.mtconnectDir;
        FileUtils.createDirectories(primaryPath);
        if (!Files.isWritable(primaryPath)) {
            LOGGER.error("Unable to write to '{}'...", (Object)primaryPath.toAbsolutePath());
            return false;
        }
        Path fullPath = this.mtconnectDir.resolve(this.binary);
        if (!MineTogetherConnect.download(fullPath)) {
            return false;
        }
        String sessionIdent = this.sessionString;
        if (sessionIdent == null || sessionIdent.isEmpty()) {
            LOGGER.error("Unable to launch MineTogether Connect as not logged in...");
            return false;
        }
        executable.add(sessionIdent);
        executable.add("true");
        ProcessBuilder pb = new ProcessBuilder(executable);
        try {
            this.vpnProcess = pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Unable to launch MineTogether Connect...", (Throwable)e);
            return false;
        }
        CompletableFuture<Void> stdoutFuture = StreamGobblerLog.redirectToLogger(this.vpnProcess.getInputStream(), this.getlogExaminer(LOGGER::info));
        CompletableFuture<Void> stderrFuture = StreamGobblerLog.redirectToLogger(this.vpnProcess.getErrorStream(), this.getlogExaminer(LOGGER::error));
        CompletableFuture.supplyAsync(() -> this.waitForInternal(this.vpnProcess)).thenRunAsync(() -> {
            if (!stdoutFuture.isDone()) {
                stdoutFuture.cancel(true);
            }
            if (!stderrFuture.isDone()) {
                stderrFuture.cancel(true);
            }
        });
        return true;
    }

    private Process waitForInternal(final Process process) {
        boolean interrupted = false;
        while (true) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        process.waitFor();
                        return true;
                    }

                    @Override
                    public boolean isReleasable() {
                        return !process.isAlive();
                    }
                });
            }
            catch (InterruptedException x) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return process;
    }

    public Consumer<String> getlogExaminer(Consumer<String> logger) {
        return line -> {
            logger.accept((String)line);
            if (this.connected) {
                return;
            }
            if (line.contains("Connection received from Java")) {
                this.connected = true;
                if (this.runConnected != null) {
                    CompletableFuture.runAsync(this.runConnected);
                }
            }
        };
    }

    private static boolean download(Path path) {
        HashCode fileHash = null;
        if (!Files.notExists(path, new LinkOption[0])) {
            try {
                fileHash = HashUtils.hash(Hashing.sha256(), path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean download = true;
        if (fileHash != null) {
            download = false;
            String hashString = WebUtils.getWebResponse("https://apps.modpacks.ch/MineTogether/GoNATProxyClient.exe.sha256").trim();
            if (!HashUtils.equals(fileHash, hashString)) {
                download = true;
            }
        }
        if (download) {
            LOGGER.info("Downloading MineTogether Connect as hash has changed or doesn't exist");
            try {
                WebUtils.downloadFile("https://apps.modpacks.ch/MineTogether/GoNATProxyClient.exe", path);
            }
            catch (Throwable e) {
                LOGGER.error("Unable to grab binaries...", e);
                return false;
            }
            return Files.exists(path, new LinkOption[0]);
        }
        return true;
    }

    public void disconnect() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.connected) {
            LOGGER.info("Not closing MineTogether Connect as might be in use by the game");
        }
        if (this.vpnProcess != null) {
            this.vpnProcess.destroy();
        }
        this.connected = false;
        if (this.runDisconnected != null) {
            CompletableFuture.runAsync(this.runDisconnected);
        }
    }
}

