/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MiscUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final Pattern p = Pattern.compile("\\w+ version \"(.*?)\"");

    public static CompletableFuture<?> allFutures(ArrayList<CompletableFuture<?>> futures) {
        CompletionStage combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).exceptionally(t -> {
            LOGGER.warn("Future failed.", (Throwable)t);
            return null;
        });
        futures.forEach((Consumer<CompletableFuture<?>>)((Consumer<CompletableFuture>)arg_0 -> MiscUtils.lambda$allFutures$2((CompletableFuture)combinedFuture, arg_0)));
        return combinedFuture;
    }

    public static int getRandomNumber(int min2, int max) {
        return (int)(Math.random() * (double)(max - min2) + (double)min2);
    }

    public static long unixtime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getDateAndTime() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        LocalDateTime now = LocalDateTime.now();
        return dateTimeFormatter.format(now);
    }

    public static boolean isInt(String in) {
        try {
            Integer.parseInt(in);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$allFutures$2(CompletableFuture combinedFuture, CompletableFuture x) {
        x.exceptionally(t -> {
            combinedFuture.completeExceptionally((Throwable)t);
            return null;
        });
    }
}

