/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.covers1624.quack.gson.HashCodeAdapter;
import net.covers1624.quack.gson.PathTypeAdapter;

public class GsonUtils {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Path.class), new PathTypeAdapter()).registerTypeAdapter((Type)((Object)HashCode.class), new HashCodeAdapter()).create();

    public static <T> T loadJson(Path path, Type type) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object t = GSON.fromJson((Reader)reader, type);
            return t;
        }
    }

    public static void saveJson(Path path, Object thing) throws IOException {
        GsonUtils.saveJson(path, thing, thing.getClass());
    }

    public static void saveJson(Path path, Object thing, Type type) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(thing, type, writer);
        }
    }
}

