/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.IChatListener;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogetherChat {
    public static Executor profileExecutor = Executors.newCachedThreadPool();
    public static Executor otherExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("minetogether-other-%d").build());
    public static Executor ircEventExecutor = Executors.newFixedThreadPool(15, new ThreadFactoryBuilder().setNameFormat("minetogether-ircevent-%d").build());
    public static Executor chatMessageExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("minetogether-chatmessage-%d").build());
    public static Executor messageHandlerExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("minetogether-messagehandler-%d").build());
    public static Executor whoIsExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("minetogether-whoisexecuter-%d").build());
    public static Executor friendExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("minetogether-friend-%d").build());
    public static boolean DEBUG_MODE = false;
    private static CompletableFuture chatThread = null;
    public String ourNick = "";
    public String realName = "";
    public String hash = null;
    public String signature = null;
    public String serverID = "";
    public static AtomicReference<Profile> profile = new AtomicReference();
    public static Logger logger = LogManager.getLogger();
    public static MineTogetherChat INSTANCE;
    public boolean online;
    public IChatListener iChatListener;

    public MineTogetherChat(String ourNick, String hash, boolean online, String realName, String signature, String serverID, IChatListener iChatListener) {
        INSTANCE = this;
        this.ourNick = ourNick;
        this.hash = hash;
        this.online = online;
        this.realName = realName;
        this.signature = signature;
        this.serverID = serverID;
        this.iChatListener = iChatListener;
    }

    public void startChat() {
        if (chatThread != null) {
            chatThread.cancel(true);
            chatThread = null;
        }
        if (profile.get() == null) {
            profile.set(new Profile(MineTogetherChat.INSTANCE.ourNick));
            CompletableFuture.runAsync(() -> {
                while (profile.get().getLongHash().isEmpty()) {
                    profile.get().loadProfile();
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, profileExecutor);
            profile.get().setPackID(this.realName);
        }
        chatThread = CompletableFuture.runAsync(() -> ChatHandler.init(this.hash, MineTogetherChat.INSTANCE.ourNick, MineTogetherChat.INSTANCE.realName, this.iChatListener, MineTogetherChat.INSTANCE.online), profileExecutor);
    }
}

