/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class FriendUpdateThread {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private static String mtHash;
    private static ScheduledFuture<?> scheduledFuture;

    public static void init(String mtHash) {
        FriendUpdateThread.mtHash = mtHash;
        Runnable runnable = FriendUpdateThread::updateFriendsList;
        scheduledFuture = executorService.scheduleAtFixedRate(runnable, 0L, 30L, TimeUnit.SECONDS);
    }

    public static void stop() {
        scheduledFuture.cancel(false);
    }

    public static void updateFriendsList() {
        try {
            JsonObject obj;
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("hash", mtHash);
            String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/listfriend", new Gson().toJson(sendMap), true, true);
            JsonElement el = new JsonParser().parse(resp);
            if (el.isJsonObject() && (obj = el.getAsJsonObject()).get("status").getAsString().equals("success")) {
                JsonArray array = obj.getAsJsonArray("friends");
                for (JsonElement friendEl : array) {
                    JsonObject friend = (JsonObject)friendEl;
                    String name = "null";
                    if (!friend.get("name").isJsonNull()) {
                        name = friend.get("name").getAsString();
                    }
                    String code = friend.get("hash").isJsonNull() ? "" : friend.get("hash").getAsString();
                    boolean accepted = friend.get("accepted").getAsBoolean();
                    Profile friendProfile = KnownUsers.findByHash(code);
                    if (friendProfile == null) {
                        friendProfile = KnownUsers.add(code);
                    }
                    friendProfile.setFriendName(name);
                    friendProfile.setFriend(accepted);
                    friendProfile.setPending(!accepted);
                    KnownUsers.update(friendProfile);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

