/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import com.google.common.hash.Hashing;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IRCServer;
import net.creeperhost.minetogether.lib.serverlists.EnumFlag;
import net.creeperhost.minetogether.lib.serverlists.FriendStatusResponse;
import net.creeperhost.minetogether.lib.serverlists.ModPack;
import net.creeperhost.minetogether.lib.serverlists.Server;
import net.creeperhost.minetogether.lib.util.WebUtils;

public final class ChatCallbacks {
    private static Map<UUID, String> hashCache = new HashMap<UUID, String>();
    private static String friendCode;
    private static IRCServer cachedIrcServer;
    public static String userCount;
    public static String onlineCount;
    private static String banMessage;
    public static String banID;
    public static Map<String, String> regionMap;
    public static Map<String, String> dataCenterMap;

    public static boolean inviteFriend(Profile profile, String hash, String ourServerID) {
        JsonObject obj;
        JsonParser parser;
        JsonElement element;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", profile.getFriendCode());
        sendMap.put("server", String.valueOf(ourServerID));
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invitefriend", sendStr, true, false);
        for (int retries = 0; resp.equals("error") && retries < 3; ++retries) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invitefriend", sendStr, true, false);
        }
        if (!resp.equals("error") && (element = (parser = new JsonParser()).parse(resp)).isJsonObject() && (obj = element.getAsJsonObject()).get("status").getAsString().equals("success")) {
            return true;
        }
        MineTogetherChat.logger.error("Unable to invite friend.");
        MineTogetherChat.logger.error(resp);
        return false;
    }

    public static void updateOnlineCount() {
        CompletableFuture.runAsync(() -> {
            if (onlineCount.equals("thousands of")) {
                String online;
                String statistics = WebUtils.getWebResponse("https://minetogether.io/api/stats/all");
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                HashMap stats = gson.fromJson(statistics, HashMap.class);
                String users = (String)stats.get("users");
                if (users != null && users.length() > 4) {
                    userCount = users;
                }
                if ((online = (String)stats.get("online")) != null && !online.equalsIgnoreCase("null")) {
                    onlineCount = online;
                }
            }
        }, MineTogetherChat.otherExecutor);
    }

    public static String getPlayerHash(UUID uuid) {
        if (hashCache.containsKey(uuid)) {
            return hashCache.get(uuid);
        }
        String playerHash = Hashing.sha256().hashBytes(uuid.toString().getBytes(StandardCharsets.UTF_8)).toString().toUpperCase();
        hashCache.put(uuid, playerHash);
        return playerHash;
    }

    public static Profile getProfile(String playerHash) {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("target", playerHash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/minetogether/profile", sendStr, true, false);
        if (resp.equalsIgnoreCase("error")) {
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonElement status = obj.get("status");
            if (status.getAsString().equals("success")) {
                JsonObject profileData = obj.getAsJsonObject("profileData").getAsJsonObject(playerHash);
                String mediumHash = profileData.getAsJsonObject("chat").getAsJsonObject("hash").get("medium").getAsString();
                String shortHash = profileData.getAsJsonObject("chat").getAsJsonObject("hash").get("short").getAsString();
                String longHash = profileData.getAsJsonObject("hash").get("long").getAsString();
                String display = profileData.get("display").getAsString();
                boolean premium = profileData.get("premium").getAsBoolean();
                boolean isOnline = profileData.getAsJsonObject("chat").get("online").getAsBoolean();
                return new Profile(longHash, shortHash, mediumHash, isOnline, display, premium);
            }
            MineTogetherChat.logger.error(resp);
        }
        return null;
    }

    public static boolean isBanned(String hash) {
        JsonParser parser;
        JsonElement element;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/minetogether/isbanned", sendStr, true, false);
        int retries = 0;
        while (resp.equals("error") && retries < 3) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/minetogether/isbanned", sendStr, true, false);
        }
        if (!resp.equals("error") && (element = (parser = new JsonParser()).parse(resp)).isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonElement status = obj.get("status");
            if (status.getAsString().equals("success")) {
                JsonElement banned = obj.get("banned");
                JsonElement ban = obj.get("ban");
                JsonElement id = ban.getAsJsonObject().get("id");
                JsonElement timestamp = ban.getAsJsonObject().get("timestamp");
                JsonElement reason = ban.getAsJsonObject().get("reason");
                banID = id.getAsString();
                banMessage = reason.getAsString();
                MineTogetherChat.profile.getAndUpdate(profile -> {
                    profile.setBanned(banned.getAsBoolean());
                    return profile;
                });
                return banned.getAsBoolean();
            }
            MineTogetherChat.logger.error(resp);
        }
        return false;
    }

    public static String getBanMessage(String hash) {
        if (banMessage == null) {
            ChatCallbacks.isBanned(hash);
        }
        if (banMessage != null) {
            return banMessage;
        }
        return "";
    }

    public static String getFriendCode(String hash) {
        if (friendCode != null) {
            return friendCode;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/friendCode", sendStr, true, false);
        for (int retries = 0; resp.equals("error") && retries < 3; ++retries) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/friendCode", sendStr, true, false);
        }
        if (!resp.equals("error")) {
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(resp);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonElement status = obj.get("status");
                if (status.getAsString().equals("success")) {
                    friendCode = obj.get("code").getAsString();
                } else {
                    MineTogetherChat.logger.error("Unable to get friendcode.");
                    MineTogetherChat.logger.error(resp);
                }
            }
            return friendCode;
        }
        return null;
    }

    public static FriendStatusResponse addFriend(String code, String display, String hash) {
        JsonParser parser;
        JsonElement element;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", code);
        sendMap.put("display", display);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/requestfriend", sendStr, true, false);
        for (int retries = 0; resp.equals("error") && retries < 3; ++retries) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/requestfriend", sendStr, true, false);
        }
        if (!resp.equals("error") && (element = (parser = new JsonParser()).parse(resp)).isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonElement status = obj.get("status");
            JsonElement message = obj.get("message");
            FriendStatusResponse friendStatusResponse = new FriendStatusResponse(status.getAsString().equalsIgnoreCase("success"), message.getAsString(), "");
            if (!status.getAsString().equals("success")) {
                if (!message.getAsString().equalsIgnoreCase("Friend request already pending.")) {
                    String friendHash = obj.get("hash").getAsString();
                    friendStatusResponse.setHash(friendHash);
                    MineTogetherChat.logger.error("Unable to add friend.");
                    MineTogetherChat.logger.error(resp);
                    return friendStatusResponse;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean removeFriend(String friendHash, String hash) {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", friendHash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/removefriend", sendStr, true, false);
        for (int retries = 0; resp.equals("error") && retries < 3; ++retries) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/removefriend", sendStr, true, false);
        }
        if (!resp.equals("error")) {
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(resp);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                JsonElement status = obj.get("status");
                JsonElement message = obj.get("message");
                if (!status.getAsString().equals("success") && !message.getAsString().equalsIgnoreCase("Friend does not exist.")) {
                    MineTogetherChat.logger.error("Unable to remove friend: " + message);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Server getServer(int id) {
        JsonObject object;
        JsonElement jElement;
        HashMap<String, String> jsonPass = new HashMap<String, String>();
        jsonPass.put("serverid", String.valueOf(id));
        Gson gson = new Gson();
        String jsonString = gson.toJson(jsonPass);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/server", jsonString, true, false);
        for (int retries = 0; resp.equals("error") && retries < 3; ++retries) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/server", jsonString, true, false);
        }
        if (!resp.equals("error") && (jElement = new JsonParser().parse(resp)).isJsonObject() && (object = jElement.getAsJsonObject()).has("status") && object.get("status").getAsString().equals("success")) {
            JsonObject server = object.get("server").getAsJsonObject();
            String host = server.get("ip").getAsString();
            String name = server.get("name").getAsString();
            String port = server.get("port").getAsString();
            int uptime = server.get("uptime").getAsInt();
            int players = server.get("expected_players").getAsInt();
            EnumFlag flag = EnumFlag.UNKNOWN;
            return new Server(name, host + ":" + port, uptime, players, flag, "", "");
        }
        return null;
    }

    public static Map<String, String> getRegionMap(boolean force) {
        if (!regionMap.isEmpty() && !force) {
            return regionMap;
        }
        Map rawMap = new HashMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            String jsonData = WebUtils.getWebResponse("https://www.creeperhost.net/json/locations");
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson g2 = new Gson();
            JsonElement el = new JsonParser().parse(jsonData);
            rawMap = (Map)g2.fromJson(el.getAsJsonObject().get("regionMap"), type);
        }
        catch (Exception e) {
            MineTogetherChat.logger.error("Unable to fetch server locations" + e);
        }
        for (Map.Entry entry : rawMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            returnMap.put(key, value);
        }
        regionMap = returnMap;
        return returnMap;
    }

    public static Map<String, String> getDataCentres(boolean force) {
        JsonArray array;
        String url = "https://www.creeperhost.net/json/datacentre/closest";
        HashMap<String, String> map = new HashMap<String, String>();
        if (!dataCenterMap.isEmpty() && !force) {
            return dataCenterMap;
        }
        String resp = WebUtils.getWebResponse(url);
        JsonElement jElement = new JsonParser().parse(resp);
        if (jElement.isJsonObject() && (array = jElement.getAsJsonObject().getAsJsonArray("datacentres")) != null) {
            for (JsonElement serverEl : array) {
                JsonObject object = (JsonObject)serverEl;
                String name = object.get("name").getAsString();
                String distance = object.get("distance").getAsString();
                map.put(name, distance);
            }
            dataCenterMap = map;
            return dataCenterMap;
        }
        return null;
    }

    public static String getVersionFromCurse(String curse) {
        if (ChatCallbacks.isInteger(curse)) {
            String resp = WebUtils.getWebResponse("https://www.creeperhost.net/json/modpacks/curseforge/" + curse, 20000);
            try {
                JsonElement jElement = new JsonParser().parse(resp);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("success")) {
                    return jObject.getAsJsonPrimitive("id").getAsString();
                }
                return "0";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "0";
    }

    public static boolean isInteger(String s2) {
        try {
            Integer.parseInt(s2);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String getVersionFromApi(String packid) {
        try {
            String resp = WebUtils.getWebResponse("https://www.creeperhost.net/json/modpacks/modpacksch/" + packid, 20000);
            JsonElement jElement = new JsonParser().parse(resp);
            JsonObject jObject = jElement.getAsJsonObject();
            if (jObject.getAsJsonPrimitive("status").getAsString().equals("success")) {
                return jObject.getAsJsonPrimitive("id").getAsString();
            }
            return "";
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static List<ModPack> getModpackFromCurse(String modpack, int limit) {
        try {
            JsonObject object;
            JsonArray array;
            String url = "https://www.creeperhost.net/json/modpacks/mc/search/unique/" + modpack;
            if (modpack == null || modpack.isEmpty()) {
                url = "https://www.creeperhost.net/json/modpacks/weekly/" + limit;
            }
            String resp = WebUtils.getWebResponse(url);
            ArrayList<ModPack> modpackList = new ArrayList<ModPack>();
            JsonElement jElement = new JsonParser().parse(resp);
            if (jElement.isJsonObject() && (array = (object = jElement.getAsJsonObject().getAsJsonObject("modpacks")).getAsJsonArray("mc")) != null) {
                for (JsonElement serverEl : array) {
                    if ((modpack == null || !modpack.isEmpty()) && modpackList.size() > limit) continue;
                    JsonObject server = (JsonObject)serverEl;
                    String id = server.get("id").getAsString();
                    String name = server.get("displayName").getAsString();
                    String displayVersion = server.get("displayVersion").getAsString();
                    String displayIcon = server.get("displayIcon").getAsString();
                    modpackList.add(new ModPack(id, name, displayVersion, displayIcon));
                }
                return modpackList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IRCServer getIRCServerDetails() {
        JsonParser parser;
        JsonObject parse;
        if (cachedIrcServer != null) {
            return cachedIrcServer;
        }
        String resp = WebUtils.getWebResponseIrcServer(120000, true);
        if (resp.equals("error")) {
            MineTogetherChat.logger.error("error while attempting to get ChatServer from url");
            return ChatCallbacks.getFallbackIrcServer();
        }
        if (MineTogetherChat.DEBUG_MODE) {
            MineTogetherChat.logger.info(resp);
        }
        if ((parse = (parser = new JsonParser()).parse(resp).getAsJsonObject()).get("status").getAsString().equals("success")) {
            IRCServer ircServer;
            String channel = parse.get("channel").getAsString();
            JsonObject server = parse.getAsJsonObject("server");
            String address = server.get("address").getAsString();
            int port = server.get("port").getAsInt();
            boolean ssl = server.get("ssl").getAsBoolean();
            cachedIrcServer = ircServer = new IRCServer(address, port, ssl, channel);
            return ircServer;
        }
        return ChatCallbacks.getFallbackIrcServer();
    }

    public static IRCServer getFallbackIrcServer() {
        IRCServer ircServer;
        cachedIrcServer = ircServer = new IRCServer("irc.minetogether.io", 6667, false, "#public");
        return ircServer;
    }

    public static String getSafe(JsonObject jsonObject, String value, String defaultString) {
        if (jsonObject == null) {
            return defaultString;
        }
        if (!jsonObject.has(value)) {
            return defaultString;
        }
        try {
            return jsonObject.get(value).getAsString();
        }
        catch (Exception e) {
            return defaultString;
        }
    }

    public static int getSafe(JsonObject jsonObject, String value, int defaultInt) {
        if (jsonObject == null) {
            return defaultInt;
        }
        if (!jsonObject.has(value)) {
            return defaultInt;
        }
        try {
            return jsonObject.get(value).getAsInt();
        }
        catch (Exception e) {
            return defaultInt;
        }
    }

    static {
        userCount = "over 2 million";
        onlineCount = "thousands of";
        banID = "";
        regionMap = new HashMap<String, String>();
        dataCenterMap = new HashMap<String, String>();
    }
}

