/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ToastHandler {
    public Runnable toastMethod;
    public ITextComponent toastText;
    public long endTime;
    public long fadeTime;
    public EnumToastType toastType;
    public int x;
    public int y;

    public void displayToast(ITextComponent text, int x, int y, int duration, EnumToastType toastType, Runnable method) {
        this.toastText = text;
        this.x = x;
        this.y = y;
        this.endTime = System.currentTimeMillis() + (long)duration;
        this.fadeTime = this.endTime + 500L;
        this.toastType = toastType;
        this.toastMethod = method;
    }

    public void displayToast(ITextComponent text, int duration, EnumToastType toastType, Runnable method) {
        this.toastText = text;
        this.x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() - 160;
        this.y = 0;
        this.endTime = System.currentTimeMillis() + (long)duration;
        this.fadeTime = this.endTime + 500L;
        this.toastType = toastType;
        this.toastMethod = method;
    }

    public void clearToast(boolean fade) {
        this.toastText = null;
        this.endTime = System.currentTimeMillis();
        this.toastMethod = null;
        this.fadeTime = this.endTime + (long)(fade ? 500 : 0);
    }

    public boolean isActiveToast() {
        return this.fadeTime >= System.currentTimeMillis();
    }

    public EnumToastType getToastType() {
        return this.toastType;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void render(MatrixStack poseStack) {
        if (MineTogetherClient.toastHandler != null && MineTogetherClient.toastHandler.toastText != null) {
            long curTime = System.currentTimeMillis();
            if (MineTogetherClient.toastHandler.fadeTime > curTime) {
                long fadeDiff = MineTogetherClient.toastHandler.fadeTime - MineTogetherClient.toastHandler.endTime;
                long curFade = Math.min(MineTogetherClient.toastHandler.fadeTime - curTime, fadeDiff);
                float alpha = (float)curFade / (float)fadeDiff;
                RenderSystem.disableLighting();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Constants.TEXTURE_TOASTS);
                List s2 = RenderComponentsUtil.func_238505_a_((ITextProperties)MineTogetherClient.toastHandler.toastText, (int)140, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                int toastHeight = 32 + s2.size() * 8;
                Screen.func_238463_a_((MatrixStack)poseStack, (int)MineTogetherClient.toastHandler.getX(), (int)MineTogetherClient.toastHandler.getY(), (float)MineTogetherClient.toastHandler.getToastType().getX(), (float)MineTogetherClient.toastHandler.getToastType().getY(), (int)160, (int)32, (int)256, (int)256);
                RenderSystem.enableBlend();
                int textColour = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                int start = MineTogetherClient.toastHandler.getY();
                for (IReorderingProcessor properties : s2) {
                    int x = this.getX() + 6;
                    if (this.toastType == EnumToastType.WARNING) {
                        x = this.getX() + 16;
                    }
                    Minecraft.func_71410_x().field_71466_p.func_238407_a_(poseStack, properties, (float)x, (float)(start += 9), textColour);
                }
            } else {
                MineTogetherClient.toastHandler.clearToast(true);
            }
        }
    }

    public static enum EnumToastType {
        DEFAULT(0, 0),
        WHITE(0, 32),
        WARNING(0, 64);

        int x;
        int y;

        private EnumToastType(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

