/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import net.creeperhost.minetogether.com.fasterxml.jackson.core.JsonGenerator;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.BeanProperty;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.JsonMappingException;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.JsonSerializer;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.SerializerProvider;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.ser.ContextualSerializer;

public final class TypeWrappedSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    protected final TypeSerializer _typeSerializer;
    protected final JsonSerializer<Object> _serializer;

    public TypeWrappedSerializer(TypeSerializer typeSer, JsonSerializer<?> ser) {
        this._typeSerializer = typeSer;
        this._serializer = ser;
    }

    @Override
    public void serialize(Object value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        this._serializer.serializeWithType(value, g2, provider, this._typeSerializer);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this._serializer.serializeWithType(value, g2, provider, typeSer);
    }

    @Override
    public Class<Object> handledType() {
        return Object.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._serializer;
        if (ser instanceof ContextualSerializer) {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (ser == this._serializer) {
            return this;
        }
        return new TypeWrappedSerializer(this._typeSerializer, ser);
    }

    public JsonSerializer<Object> valueSerializer() {
        return this._serializer;
    }

    public TypeSerializer typeSerializer() {
        return this._typeSerializer;
    }
}

