/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.fae.FaeAIFollow;
import stepsword.mahoutsukai.entity.fae.FaeAIWander;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.FaeNoisePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeEntity
extends AnimalEntity
implements IFlyingAnimal {
    public static final String entityName = "fae";
    public static final String chime = "";
    public static ResourceLocation loot = new ResourceLocation("mahoutsukai", "fae");
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(FaeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(FaeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(FaeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";

    public FaeEntity(World worldIn) {
        super(ModEntities.FAE, worldIn);
        this.field_70158_ak = true;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.randomColor();
    }

    public FaeEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.FAE, worldIn);
        this.field_70158_ak = true;
    }

    public FaeEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
        this.field_70158_ak = true;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.randomColor();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return new FaeEntity((World)world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FaeAIFollow((CreatureEntity)this, 1.0, 8.0f, 7.0f, 2.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new FaeAIWander((CreatureEntity)this, 1.0, 1));
        this.field_70714_bg.func_75776_a(0, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
    }

    public void func_70636_d() {
        float[] colors;
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        super.func_70636_d();
        AxisAlignedBB bb = this.func_174813_aQ();
        if (!this.field_70170_p.field_72995_K && (colors = this.getColor())[0] == colors[1] && colors[1] == colors[2]) {
            this.randomColor();
        }
        x = this.func_226277_ct_();
        y = this.func_226278_cu_();
        z = this.func_226281_cx_();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator pathnavigateflying = new FlyingPathNavigator((MobEntity)this, worldIn){};
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    protected void func_85033_bc() {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        Item[] tasty;
        for (Item item : tasty = new Item[]{ModItems.powderedEye, ModItems.powderedEmerald, ModItems.powderedIron, ModItems.powderedDiamond, ModItems.powderedEnder, ModItems.powderedQuartz, ModItems.powderedGold}) {
            if (item != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public void func_213352_e(Vector3d v) {
        float strafe = (float)v.field_72450_a;
        float vertical = (float)v.field_72448_b;
        float forward = (float)v.field_72449_c;
        Vector3d motion = this.func_213322_ci();
        double motionX = motion.field_72450_a;
        double motionY = motion.field_72448_b;
        double motionZ = motion.field_72449_c;
        float ff = 0.008f;
        if (!Utils.isBlockAir(this.field_70170_p, this.func_233580_cy_().func_177977_b())) {
            motionY += (double)ff;
        }
        this.func_213293_j(motionX, motionY, motionZ);
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, v);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, v);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            float f = 0.91f;
            if (this.func_233570_aj_()) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()));
                BlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_213309_a(this.func_233570_aj_() ? 0.1f * f1 : 0.02f, v);
            f = 0.91f;
            if (this.func_233570_aj_()) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()));
                BlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.func_226277_ct_() - this.field_70169_q;
        double d0 = this.func_226281_cx_() - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void randomColor() {
        float b;
        float g;
        float r;
        int choice = this.func_70681_au().nextInt(11);
        if (choice == 0) {
            r = 140.0f;
            g = 0.0f;
            b = 255.0f;
        } else if (choice == 1) {
            r = 51.0f;
            g = 241.0f;
            b = 255.0f;
        } else if (choice == 2) {
            r = 255.0f;
            g = 94.0f;
            b = 0.0f;
        } else if (choice == 3) {
            r = 0.0f;
            g = 222.0f;
            b = 18.0f;
        } else if (choice == 4) {
            r = 255.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (choice == 5) {
            r = 255.0f;
            g = 209.0f;
            b = 41.0f;
        } else if (choice == 6) {
            r = 26.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 7) {
            r = 68.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 8) {
            r = 255.0f;
            g = 150.0f;
            b = 201.0f;
        } else if (choice == 9) {
            r = 172.0f;
            g = 255.0f;
            b = 28.0f;
        } else {
            r = 255.0f;
            g = 28.0f;
            b = 77.0f;
        }
        this.setColor(r, g, b);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
    }

    public void setColor(float r, float g, float b) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.func_174810_b(false);
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue()};
    }

    public float func_213355_cm() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        boolean faesound;
        boolean bl = faesound = MTConfig.FAE_NOISE && MahouTsukaiMod.proxy.isMahouTsukai();
        if (faesound) {
            int z = this.func_70681_au().nextInt(4);
            SoundEvent[] arr = new SoundEvent[]{ModSounds.FAE_CHIME_1, ModSounds.FAE_CHIME_2, ModSounds.FAE_CHIME_3, ModSounds.FAE_CHIME_4};
            return arr[z];
        }
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R()) {
            if (!this.field_70170_p.field_72995_K) {
                this.playSound(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch);
            } else if (MahouTsukaiMod.proxy.isMahouTsukai()) {
                // empty if block
            }
        }
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.sendToAllNear(this.field_70170_p.func_73046_m().func_184103_al(), x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, EffectUtil.getDimension(this.field_70170_p), new FaeNoisePacket((int)x, (int)y, (int)z, soundIn, category, volume, pitch));
    }

    public void sendToAllNear(PlayerList list, double x, double y, double z, double radius, ResourceLocation dimension, FaeNoisePacket packetIn) {
        if (list != null) {
            for (int i = 0; i < list.func_181057_v().size(); ++i) {
                double d2;
                double d1;
                double d0;
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)list.func_181057_v().get(i);
                IMahou mahou = Utils.getPlayerMahou((PlayerEntity)serverplayerentity);
                if (mahou == null || !mahou.hasMagic() || !EffectUtil.compareDimensions(EffectUtil.getDimension(serverplayerentity.field_70170_p), dimension) || !((d0 = x - serverplayerentity.func_226277_ct_()) * d0 + (d1 = y - serverplayerentity.func_226278_cu_()) * d1 + (d2 = z - serverplayerentity.func_226281_cx_()) * d2 < radius * radius)) continue;
                PacketHandler.sendTo(serverplayerentity, packetIn);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return loot;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233822_e_, (double)0.8f).func_233815_a_(Attributes.field_233821_d_, (double)0.4f);
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        if (reason == SpawnReason.BREEDING || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.MOB_SUMMONED) {
            return true;
        }
        Leylines.LeyLineShape keepshape = Leylines.LeyLineShape.NONE;
        ChunkPos cp = new ChunkPos(this.func_233580_cy_());
        for (int i = cp.func_180334_c(); i <= cp.func_180332_e(); ++i) {
            for (int j = cp.func_180333_d(); j <= cp.func_180330_f(); ++j) {
                Leylines.LeyLineShape shape = Leylines.leyOrientation(new BlockPos(i, 0, j));
                if (keepshape == Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape == Leylines.LeyLineShape.NED || keepshape == Leylines.LeyLineShape.NWD || keepshape == Leylines.LeyLineShape.HORIZ || keepshape == Leylines.LeyLineShape.VERT && shape != Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape != Leylines.LeyLineShape.CROSS || shape != Leylines.LeyLineShape.STAR) continue;
                keepshape = Leylines.LeyLineShape.STAR;
            }
        }
        float thresh = 1.0f;
        thresh = keepshape == Leylines.LeyLineShape.CROSS ? 0.2f : (keepshape == Leylines.LeyLineShape.STAR ? 0.0f : (keepshape == Leylines.LeyLineShape.NONE ? 0.7f : 0.4f));
        thresh = (float)((double)thresh * MTConfig.FAE_SPAWN_RATE);
        return Math.random() > (double)thresh && super.func_213380_a(world, reason);
    }

    public static boolean getCanSpawnHere(EntityType<FaeEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (reason == SpawnReason.BREEDING || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.MOB_SUMMONED) {
            return true;
        }
        Leylines.LeyLineShape keepshape = Leylines.LeyLineShape.NONE;
        ChunkPos cp = new ChunkPos(pos);
        for (int i = cp.func_180334_c(); i <= cp.func_180332_e(); ++i) {
            for (int j = cp.func_180333_d(); j <= cp.func_180330_f(); ++j) {
                Leylines.LeyLineShape shape = Leylines.leyOrientation(new BlockPos(i, 0, j));
                if (keepshape == Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape == Leylines.LeyLineShape.NED || keepshape == Leylines.LeyLineShape.NWD || keepshape == Leylines.LeyLineShape.HORIZ || keepshape == Leylines.LeyLineShape.VERT && shape != Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape != Leylines.LeyLineShape.CROSS || shape != Leylines.LeyLineShape.STAR) continue;
                keepshape = Leylines.LeyLineShape.STAR;
            }
        }
        float thresh = 1.0f;
        thresh = keepshape == Leylines.LeyLineShape.CROSS ? 0.2f : (keepshape == Leylines.LeyLineShape.STAR ? 0.0f : (keepshape == Leylines.LeyLineShape.NONE ? 0.7f : 0.4f));
        thresh = (float)((double)thresh * MTConfig.FAE_SPAWN_RATE);
        return random.nextDouble() > (double)thresh;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_76379_h || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_188406_j;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B));
    }

    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isFlying() {
        return !this.func_233570_aj_();
    }

    public boolean func_82150_aj() {
        return true;
    }
}

