/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.top;

import java.text.DecimalFormat;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TOPPlugin
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    private static final DecimalFormat format = new DecimalFormat("#");

    public String getID() {
        return "botanypots:top_support";
    }

    @Override
    public Void apply(ITheOneProbe top) {
        top.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState state, IProbeHitData hit) {
        TileEntity tile;
        Block block = state.func_177230_c();
        if (block instanceof BlockBotanyPot && (tile = world.func_175625_s(hit.getPos())) instanceof TileEntityBotanyPot) {
            this.addPotInfo((TileEntityBotanyPot)tile, ((BlockBotanyPot)block).isHopper(), info);
        }
    }

    private void addPotInfo(TileEntityBotanyPot pot, boolean isHopper, IProbeInfo info) {
        if (pot.getSoil() != null) {
            info.text((ITextComponent)new TranslationTextComponent("botanypots.tooltip.soil", new Object[]{new TranslationTextComponent(pot.getSoil().getRenderState().getState().func_177230_c().func_149739_a())}));
        }
        if (pot.getCrop() != null) {
            info.text((ITextComponent)new TranslationTextComponent("botanypots.tooltip.crop", new Object[]{new TranslationTextComponent(pot.getCrop().getDisplayState()[0].getState().func_177230_c().func_149739_a())}));
        }
        if (pot.getCurrentGrowthTicks() > 0) {
            int ticksRemaining = pot.getTotalGrowthTicks() - pot.getCurrentGrowthTicks();
            info.text((ITextComponent)new TranslationTextComponent("botanypots.tooltip.growth_time", new Object[]{TOPPlugin.ticksToElapsedTime(ticksRemaining)}));
        }
        if (pot.getCrop() != null && pot.getSoil() != null) {
            ProgressStyle style = new ProgressStyle();
            style.filledColor(-13447886);
            style.alternateFilledColor(-14313179);
            style.prefix("Progress: ");
            style.suffix("%");
            int f = MathHelper.func_76141_d((float)(pot.getGrowthPercent() * 100.0f));
            info.progress(f, 100, (IProgressStyle)style);
        }
    }

    private static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }
}

