/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.block.BlockDrillPipe;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerGasLift;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityGasLift
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityGasLift>,
ISerializableTanks,
IAutoFluidEjecting,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 1;
    @GuiSynced
    private final GasLiftFluidTank tank = new GasLiftFluidTank();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() == ((BlockDrillPipe)ModBlocks.DRILL_PIPE.get()).func_199767_j();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    public int currentDepth;
    @GuiSynced
    public final RedstoneController<TileEntityGasLift> rsController = new RedstoneController<TileEntityGasLift>(this);
    @GuiSynced
    public PumpMode pumpMode = PumpMode.PUMP_EMPTY;
    @GuiSynced
    public Status status = Status.IDLE;
    private int workTimer;
    private int ticker;
    private List<BlockPos> pumpingLake;
    private static final int MAX_PUMP_RANGE_SQUARED = 225;

    public TileEntityGasLift() {
        super((TileEntityType)ModTileEntities.GAS_LIFT.get(), 5.0f, 7.0f, 3000, 4);
    }

    @Override
    public boolean canConnectPneumatic(Direction d) {
        return d != Direction.DOWN;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.tank.tick();
        if (!this.func_145831_w().field_72995_K) {
            int curCheckingPipe;
            ++this.ticker;
            if (this.currentDepth > 0 && (curCheckingPipe = this.ticker % this.currentDepth) > 0 && !this.isPipe(this.field_145850_b, this.func_174877_v().func_177967_a(Direction.DOWN, curCheckingPipe))) {
                this.currentDepth = curCheckingPipe - 1;
            }
            if (this.ticker == 400) {
                this.pumpingLake = null;
                this.ticker = 0;
            }
            if (this.rsController.shouldRun() && this.getPressure() >= this.getMinWorkingPressure()) {
                this.workTimer = (int)((float)this.workTimer + this.getSpeedMultiplierFromUpgrades());
                while (this.workTimer > 20) {
                    this.workTimer -= 20;
                    this.status = Status.IDLE;
                    if (this.pumpMode == PumpMode.RETRACT) {
                        this.retractPipes();
                        continue;
                    }
                    if (this.suckLiquid() || this.tryDigDown()) continue;
                    break;
                }
            } else {
                this.status = Status.IDLE;
            }
        }
    }

    private void retractPipes() {
        if (this.currentDepth > 0) {
            this.status = Status.RETRACTING;
            if (this.isPipe(this.field_145850_b, this.func_174877_v().func_177982_a(0, -this.currentDepth, 0))) {
                BlockPos pos1 = this.func_174877_v().func_177967_a(Direction.DOWN, this.currentDepth);
                ItemStack toInsert = new ItemStack((IItemProvider)this.field_145850_b.func_180495_p(pos1).func_177230_c());
                if (this.inventory.insertItem(0, toInsert, true).func_190926_b()) {
                    this.inventory.insertItem(0, toInsert, false);
                    this.field_145850_b.func_175655_b(pos1, false);
                    this.addAir(-100);
                    --this.currentDepth;
                } else {
                    this.status = Status.IDLE;
                }
            } else {
                --this.currentDepth;
            }
        }
    }

    private boolean tryDigDown() {
        if (this.isUnbreakable(this.func_174877_v().func_177967_a(Direction.DOWN, this.currentDepth + 1))) {
            this.status = Status.STUCK;
        } else if (this.func_174877_v().func_177956_o() - this.currentDepth >= 0) {
            this.status = Status.DIGGING;
            ++this.currentDepth;
            BlockPos pos1 = this.func_174877_v().func_177967_a(Direction.DOWN, this.currentDepth);
            if (!this.isPipe(this.field_145850_b, pos1)) {
                ItemStack extracted = this.inventory.extractItem(0, 1, true);
                if (extracted.func_77973_b() == ((BlockDrillPipe)ModBlocks.DRILL_PIPE.get()).func_199767_j()) {
                    BlockState currentState = this.field_145850_b.func_180495_p(pos1);
                    BlockState newState = ((BlockItem)extracted.func_77973_b()).func_179223_d().func_176223_P();
                    int airRequired = Math.round(66.66f * currentState.func_185887_b((IBlockReader)this.field_145850_b, pos1));
                    if (this.airHandler.getAir() > airRequired) {
                        this.inventory.extractItem(0, 1, false);
                        this.field_145850_b.func_175655_b(pos1, false);
                        this.field_145850_b.func_175656_a(pos1, newState);
                        this.workTimer = 19;
                        this.addAir(-airRequired);
                    } else {
                        this.status = Status.IDLE;
                        --this.currentDepth;
                    }
                } else {
                    this.status = Status.IDLE;
                    --this.currentDepth;
                }
            }
        } else {
            this.status = Status.IDLE;
        }
        return this.status == Status.DIGGING;
    }

    private boolean isPipe(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == ModBlocks.DRILL_PIPE.get();
    }

    private boolean isUnbreakable(BlockPos pos) {
        return this.func_145831_w().func_180495_p(pos).func_185887_b((IBlockReader)this.field_145850_b, pos) < 0.0f;
    }

    private boolean suckLiquid() {
        BlockPos pos = this.func_174877_v().func_177967_a(Direction.DOWN, this.currentDepth + 1);
        FluidState fluidState = this.field_145850_b.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204541_a) {
            this.pumpingLake = null;
            return false;
        }
        FluidStack fluidStack = new FluidStack(fluidState.func_206886_c(), 1000);
        if (this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount()) {
            FluidStack taken;
            if (this.pumpingLake == null) {
                this.findLake(fluidStack.getFluid());
            }
            boolean foundSource = false;
            BlockPos curPos = null;
            while (this.pumpingLake.size() > 0) {
                curPos = this.pumpingLake.get(0);
                if (FluidUtils.isSourceFluidBlock(this.func_145831_w(), curPos, fluidStack.getFluid())) {
                    foundSource = true;
                    break;
                }
                this.pumpingLake.remove(0);
            }
            if (this.pumpingLake.isEmpty()) {
                this.pumpingLake = null;
            } else if (foundSource && (taken = FluidUtils.tryPickupFluid(this.fluidCap, this.field_145850_b, curPos, false, IFluidHandler.FluidAction.EXECUTE)).getAmount() == 1000) {
                this.addAir(-100);
                this.status = Status.PUMPING;
            }
        }
        return true;
    }

    private void findLake(Fluid fluid) {
        this.pumpingLake = new ArrayList<BlockPos>();
        Stack<BlockPos> pendingPositions = new Stack<BlockPos>();
        BlockPos thisPos = this.func_174877_v().func_177967_a(Direction.DOWN, this.currentDepth + 1);
        pendingPositions.add(thisPos);
        this.pumpingLake.add(thisPos);
        while (!pendingPositions.empty()) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : DirectionUtil.VALUES) {
                BlockPos newPos;
                if (d == Direction.DOWN || !(PneumaticCraftUtils.distBetweenSq(newPos = checkingPos.func_177972_a(d), thisPos) <= 225.0) || !FluidUtils.isSourceFluidBlock(this.func_145831_w(), newPos, fluid) || this.pumpingLake.contains(newPos)) continue;
                pendingPositions.add(newPos);
                this.pumpingLake.add(newPos);
            }
        }
        this.pumpingLake.sort(new ChunkPositionSorter((double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o() - this.currentDepth - 1, (double)this.func_174877_v().func_177952_p() + 0.5, IBlockOrdered.Ordering.HIGH_TO_LOW));
        Collections.reverse(this.pumpingLake);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.pumpMode = PumpMode.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public RedstoneController<TileEntityGasLift> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f + (float)this.currentDepth * 0.05f;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        tag.func_74778_a("mode", this.pumpMode.toString());
        tag.func_74768_a("currentDepth", this.currentDepth);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        if (tag.func_74764_b("mode")) {
            this.pumpMode = PumpMode.valueOf(tag.func_74779_i("mode"));
        }
        this.currentDepth = tag.func_74762_e("currentDepth");
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidCap);
        }
        return super.getCapability(cap, facing);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerGasLift(i, playerInventory, this.func_174877_v());
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    private class GasLiftFluidTank
    extends SmartSyncTank {
        GasLiftFluidTank() {
            super(TileEntityGasLift.this, 16000);
        }

        @Override
        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int inTank = this.fluid.getAmount();
            int amount = TileEntityGasLift.this.pumpMode == PumpMode.PUMP_LEAVE_FLUID ? Math.max(0, inTank - 1) : inTank;
            return super.drain(Math.min(maxDrain, amount), action);
        }
    }

    public static enum PumpMode {
        PUMP_EMPTY,
        PUMP_LEAVE_FLUID,
        RETRACT;

    }

    public static enum Status implements ITranslatableEnum
    {
        IDLE("idling"),
        PUMPING("pumping"),
        DIGGING("diggingDown"),
        RETRACTING("retracting"),
        STUCK("stuck");

        private final String desc;

        private Status(String desc) {
            this.desc = desc;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.status.gasLift.action." + this.desc;
        }
    }
}

