/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.HoldingEnchantableProvider;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public class CoFHCore
implements IThirdParty {
    static Enchantment holdingEnchantment = null;
    private static boolean versionOK;

    @Override
    public void preInit() {
        versionOK = CoFHCore.versionOK();
    }

    @Override
    public void init() {
        if (versionOK && (holdingEnchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("cofh_core", "holding"))) != null) {
            PneumaticRegistry.getInstance().getItemRegistry().registerPneumaticVolumeModifier((stack, oldVolume) -> oldVolume * (1 + EnchantmentHelper.func_77506_a((Enchantment)holdingEnchantment, (ItemStack)stack)));
        }
    }

    public static int getHoldingUpgrades(ItemStack stack) {
        return holdingEnchantment == null ? 0 : EnchantmentHelper.func_77506_a((Enchantment)holdingEnchantment, (ItemStack)stack);
    }

    public static ITextComponent holdingEnchantmentName(int level) {
        return holdingEnchantment == null ? StringTextComponent.field_240750_d_ : holdingEnchantment.func_200305_d(level);
    }

    private static boolean versionOK() {
        try {
            Class.forName("cofh.lib.capability.IEnchantableItem");
            return true;
        }
        catch (ClassNotFoundException e) {
            Log.error("PneumaticCraft: Repressurized found an older (pre-1.2.0) release of CoFH Core. Continuing, but PneumaticCraft items won't be able to use the Holding enchantment. Upgrade to CoFH Core 1.2.0 or later if possible.", new Object[0]);
            return false;
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void attachCap(AttachCapabilitiesEvent<ItemStack> event) {
            if (versionOK && holdingEnchantment != null && HoldingEnchantableProvider.CAPABILITY_ENCHANTABLE_ITEM != null && ((ItemStack)event.getObject()).func_77973_b() instanceof IPressurizableItem) {
                event.addCapability(PneumaticRegistry.RL("cofh_enchantable"), (ICapabilityProvider)new HoldingEnchantableProvider());
            }
        }
    }
}

