/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellContainer;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsRequester;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2PNCAddon;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AE2RequesterIntegration
implements IGridBlock,
IGridHost,
ICraftingProvider,
ICraftingWatcherHost,
IStackWatcherHost,
ICellContainer,
IGridTickable,
IMEInventoryHandler<IAEItemStack> {
    private final EntityLogisticsRequester logisticsRequester;
    private IGridNode gridNode;
    private ICraftingGrid craftingGrid;
    private IStackWatcher stackWatcher;
    private ICraftingWatcher craftingWatcher;
    private boolean needToCheckForInterface = true;
    private final Set<IProvidingInventoryListener.TileEntityAndFace> providingInventories = new HashSet<IProvidingInventoryListener.TileEntityAndFace>();

    public AE2RequesterIntegration(EntityLogisticsRequester logisticsRequester) {
        this.logisticsRequester = logisticsRequester;
    }

    public void maybeAddTE(IProvidingInventoryListener.TileEntityAndFace teAndFace) {
        if (this.gridNode != null) {
            this.providingInventories.add(teAndFace);
        }
    }

    public void maybeCheckForInterface() {
        if (this.needToCheckForInterface) {
            this.needToCheckForInterface = this.logisticsRequester.isAE2enabled() && this.gridNode == null ? this.checkForInterface() : false;
        }
    }

    public boolean isPlacedOnInterface() {
        return AE2PNCAddon.api.definitions().blocks().iface().maybeEntity().map(e -> e.isInstance(this.logisticsRequester.getCachedTileEntity())).orElse(false);
    }

    public void shutdown() {
        if (this.gridNode != null) {
            this.gridNode.destroy();
            this.gridNode = null;
        }
    }

    public void setEnabled(boolean ae2enabled) {
        this.needToCheckForInterface = ae2enabled;
        if (!ae2enabled && this.gridNode != null) {
            this.shutdown();
        }
    }

    private boolean checkForInterface() {
        TileEntity te;
        if (this.isPlacedOnInterface() && (te = this.logisticsRequester.getCachedTileEntity()) instanceof IGridHost) {
            IGridNode nodeA = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL);
            IGridNode nodeB = this.getGridNode(AEPartLocation.INTERNAL);
            if (nodeA == null || nodeB == null) {
                return true;
            }
            try {
                AE2PNCAddon.api.grid().createGridConnection(nodeA, nodeB);
            }
            catch (FailedConnectionException e) {
                Log.error("Couldn't connect to an ME Interface!", new Object[0]);
                e.printStackTrace();
            }
        }
        return false;
    }

    public AECableType getCableConnectionType(AEPartLocation arg0) {
        return AECableType.NONE;
    }

    public void securityBreak() {
        this.logisticsRequester.func_70106_y();
    }

    public IGridNode getGridNode(AEPartLocation d) {
        if (this.gridNode == null) {
            this.gridNode = AE2PNCAddon.api.grid().createGridNode((IGridBlock)this);
        }
        return this.gridNode;
    }

    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Nonnull
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    public boolean isWorldAccessible() {
        return false;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.logisticsRequester.getWorld(), this.logisticsRequester.getBlockPos());
    }

    @Nonnull
    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public void onGridNotification(@Nonnull GridNotification gridNotification) {
    }

    @Nonnull
    public EnumSet<Direction> getConnectableSides() {
        return EnumSet.noneOf(Direction.class);
    }

    @Nonnull
    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
    }

    @Nonnull
    public ItemStack getMachineRepresentation() {
        return new ItemStack((IItemProvider)ModItems.LOGISTICS_FRAME_REQUESTER.get());
    }

    public void provideCrafting(ICraftingProviderHelper iCraftingProviderHelper) {
        this.updateProvidingItems(iCraftingProviderHelper);
    }

    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, CraftingInventory craftingInventory) {
        return false;
    }

    public boolean isBusy() {
        return true;
    }

    public void updateWatcher(ICraftingWatcher watcher) {
        this.craftingWatcher = watcher;
        this.updateProvidingItems(null);
    }

    public void onRequestChange(ICraftingGrid grid, IAEItemStack aeStack) {
        this.craftingGrid = grid;
        int freeSlot = -1;
        for (int i = 0; i < this.getFilters().getSlots(); ++i) {
            ItemStack filterStack = this.getFilters().getStackInSlot(i);
            if (!filterStack.func_190926_b()) {
                if (!aeStack.isSameType(filterStack)) continue;
                filterStack.func_190920_e((int)grid.requesting(aeStack));
                return;
            }
            if (freeSlot != -1) continue;
            freeSlot = i;
        }
        if (freeSlot >= 0) {
            this.getFilters().setStackInSlot(freeSlot, aeStack.createItemStack());
        }
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.getGridNode(null);
    }

    public void updateWatcher(IStackWatcher watcher) {
        this.stackWatcher = watcher;
        this.updateProvidingItems(null);
    }

    public void onStackChange(IItemList<?> iItemList, IAEStack<?> iaeStack, IAEStack<?> iaeStack1, IActionSource iActionSource, IStorageChannel<?> iStorageChannel) {
        if (this.craftingGrid != null) {
            for (int i = 0; i < this.getFilters().getSlots(); ++i) {
                ItemStack s = this.getFilters().getStackInSlot(i);
                if (s.func_190926_b() || this.craftingGrid.isRequesting((IAEItemStack)((IItemStorageChannel)AE2PNCAddon.api.storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)s))) continue;
                this.getFilters().setStackInSlot(i, ItemStack.field_190927_a);
                this.notifyNetworkOfCraftingChange();
            }
        }
    }

    private IItemHandlerModifiable getFilters() {
        return this.logisticsRequester.getItemFilterHandler();
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode iGridNode) {
        return new TickingRequest(120, 120, false, false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode iGridNode, int i) {
        this.notifyNetworkOfCraftingChange();
        if (this.gridNode != null) {
            this.getGridNode(null).getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        return TickRateModulation.SAME;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ;
    }

    public boolean isPrioritized(IAEItemStack iaeItemStack) {
        return false;
    }

    public boolean canAccept(IAEItemStack iaeItemStack) {
        return false;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IAEItemStack injectItems(IAEItemStack iaeItemStack, Actionable actionable, IActionSource iActionSource) {
        return iaeItemStack;
    }

    public IAEItemStack extractItems(IAEItemStack iaeItemStack, Actionable actionable, IActionSource iActionSource) {
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> iItemList) {
        for (IAEItemStack stack : this.getProvidingItems(true)) {
            stack.setCountRequestable(stack.getStackSize());
            iItemList.addRequestable((IAEStack)stack);
        }
        return iItemList;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return AE2PNCAddon.api.storage().getStorageChannel(IItemStorageChannel.class);
    }

    public void blinkCell(int i) {
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (channel == AE2PNCAddon.api.storage().getStorageChannel(IItemStorageChannel.class)) {
            return Collections.singletonList(this);
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public int getPriority() {
        return 0;
    }

    public void saveChanges(@Nullable ICellInventory<?> iCellInventory) {
    }

    private void updateProvidingItems(ICraftingProviderHelper cHelper) {
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
        }
        if (this.craftingWatcher != null) {
            this.craftingWatcher.reset();
        }
        for (IAEItemStack stack : this.getProvidingItems(false)) {
            if (this.stackWatcher != null) {
                this.stackWatcher.add((IAEStack)stack);
            }
            if (this.craftingWatcher != null) {
                this.craftingWatcher.add((IAEStack)stack);
            }
            if (cHelper == null) continue;
            cHelper.setEmitable(stack);
        }
        for (int i = 0; i < this.logisticsRequester.getItemFilterHandler().getSlots(); ++i) {
            IAEItemStack stack;
            stack = this.logisticsRequester.getItemFilterHandler().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            IAEItemStack iaeStack = (IAEItemStack)((IItemStorageChannel)AE2PNCAddon.api.storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
            if (this.stackWatcher != null) {
                this.stackWatcher.add((IAEStack)iaeStack);
            }
            if (this.craftingWatcher != null) {
                this.craftingWatcher.add((IAEStack)iaeStack);
            }
            if (cHelper == null) continue;
            cHelper.setEmitable(iaeStack);
        }
    }

    private List<IAEItemStack> getProvidingItems(boolean initialList) {
        ArrayList<IAEItemStack> stacks = new ArrayList<IAEItemStack>();
        Iterator<IProvidingInventoryListener.TileEntityAndFace> iter = this.providingInventories.iterator();
        while (iter.hasNext()) {
            IProvidingInventoryListener.TileEntityAndFace teFace = iter.next();
            boolean ok = false;
            if (this.isLogisticsTEvalid(teFace.getTileEntity())) {
                ok = IOHelper.getInventoryForTE(teFace.getTileEntity(), teFace.getFace()).map(inv -> {
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        IAEItemStack aeStack;
                        ItemStack stack = inv.getStackInSlot(i);
                        if (stack.func_190926_b() || (aeStack = (IAEItemStack)((IItemStorageChannel)AE2PNCAddon.api.storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack)) == null) continue;
                        stacks.add(initialList ? aeStack : (IAEItemStack)((IAEItemStack)aeStack.setStackSize(0L)).setCountRequestable((long)stack.func_190916_E()));
                    }
                    return true;
                }).orElse(false);
            }
            if (ok) continue;
            iter.remove();
        }
        return stacks;
    }

    private boolean isLogisticsTEvalid(TileEntity te) {
        return !te.func_145837_r() && SemiblockTracker.getInstance().getAllSemiblocks(te.func_145831_w(), te.func_174877_v()).filter(semiblock -> semiblock instanceof EntityLogisticsFrame).anyMatch(semiblock -> ((EntityLogisticsFrame)semiblock).shouldProvideTo(this.logisticsRequester.getPriority()));
    }

    private void notifyNetworkOfCraftingChange() {
        if (this.gridNode != null) {
            this.gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.gridNode));
        }
    }
}

