/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.config.subconfig.ThirdPartyConfig;
import me.desht.pneumaticcraft.common.thirdparty.GenericIntegrationHandler;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.botania.Botania;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.CoFHCore;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ComputerCraft;
import me.desht.pneumaticcraft.common.thirdparty.create.Create;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.gamestages.Gamestages;
import me.desht.pneumaticcraft.common.thirdparty.immersiveengineering.ImmersiveEngineering;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mekanism;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraftforge.fml.ModList;

public enum ThirdPartyManager {
    INSTANCE;

    private static final GenericIntegrationHandler GENERIC;
    private static final IThirdParty IMPLICIT_INIT;
    private final List<IThirdParty> thirdPartyMods = new ArrayList<IThirdParty>();
    private IDocsProvider docsProvider = new IDocsProvider.NoDocsProvider();
    private final Set<ModType> loadedModTypes = EnumSet.noneOf(ModType.class);

    public static ThirdPartyManager instance() {
        return INSTANCE;
    }

    public IDocsProvider getDocsProvider() {
        return this.docsProvider;
    }

    private void discoverMods() {
        HashMap<String, Supplier<IThirdParty>> thirdPartyClasses = new HashMap<String, Supplier<IThirdParty>>();
        try {
            thirdPartyClasses.put("computercraft", () -> new ComputerCraft());
            thirdPartyClasses.put("waila", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("theoneprobe", () -> new TheOneProbe());
            thirdPartyClasses.put("curios", () -> new Curios());
            thirdPartyClasses.put("botania", () -> new Botania());
            thirdPartyClasses.put("patchouli", () -> new Patchouli());
            thirdPartyClasses.put("jei", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("immersiveengineering", () -> new ImmersiveEngineering());
            thirdPartyClasses.put("mekanism", () -> new Mekanism());
            thirdPartyClasses.put("appliedenergistics2", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("cofh_core", () -> new CoFHCore());
            thirdPartyClasses.put("crafttweaker", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("gamestages", () -> new Gamestages());
            thirdPartyClasses.put("create", () -> new Create());
        }
        catch (Throwable e) {
            Log.error("A class loader loaded a class where we didn't expect it to do so! Please report, as third party content is broken.", new Object[0]);
            e.printStackTrace();
        }
        ThirdPartyConfig.setupDefaults(thirdPartyClasses.keySet());
        Set enabledThirdParty = thirdPartyClasses.keySet().stream().filter(ThirdPartyConfig::isEnabled).collect(Collectors.toSet());
        ArrayList modNames = new ArrayList();
        for (Map.Entry entry : thirdPartyClasses.entrySet()) {
            if (!enabledThirdParty.contains(entry.getKey()) || !ModList.get().isLoaded((String)entry.getKey())) continue;
            IThirdParty mod = (IThirdParty)((Supplier)entry.getValue()).get();
            this.thirdPartyMods.add(mod);
            if (mod.modType() != null) {
                this.loadedModTypes.add(mod.modType());
            }
            modNames.add(entry.getKey());
        }
        Log.info("Thirdparty integration activated for [" + String.join((CharSequence)",", modNames) + "]", new Object[0]);
    }

    public void preInit() {
        this.discoverMods();
        GENERIC.preInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.preInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PreInit phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void init() {
        GENERIC.init();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.init();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the Init phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        GENERIC.postInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.postInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PostInit phase!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void clientInit() {
        GENERIC.clientInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientInit();
                if (!(thirdParty instanceof IDocsProvider)) continue;
                this.docsProvider = (IDocsProvider)((Object)thirdParty);
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side on the init!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public boolean isModTypeLoaded(ModType modType) {
        return this.loadedModTypes.contains((Object)modType);
    }

    static {
        GENERIC = new GenericIntegrationHandler();
        IMPLICIT_INIT = new IThirdParty(){};
    }

    public static enum ModType {
        COMPUTER,
        DOCUMENTATION;

    }
}

