/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    private boolean[] accessingSides = new boolean[]{false, true, false, false, false, false};
    private boolean useCount;
    private int count = 1;

    public ProgWidgetInventoryBase(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.accessingSides", new Object[0]));
        }
        curTooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_230529_a_(this.getExtraStringInfo().get(0)));
        if (this.useCount) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.count));
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return Collections.singletonList(ALL_TEXT);
        }
        if (noSides) {
            return Collections.singletonList(NONE_TEXT);
        }
        List l = Arrays.stream(DirectionUtil.VALUES).filter(side -> this.accessingSides[side.func_176745_a()]).map(ClientUtils::translateDirection).collect(Collectors.toList());
        return Collections.singletonList(new StringTextComponent(Strings.join(l, (String)", ")));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            tag.func_74757_a(Direction.func_82600_a((int)i).name(), true);
        }
        if (this.useCount) {
            tag.func_74757_a("useCount", true);
        }
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(Direction.func_82600_a((int)i).name());
        }
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        for (int i = 0; i < 6; ++i) {
            buf.writeBoolean(this.accessingSides[i]);
        }
        buf.writeBoolean(this.useCount);
        buf.func_150787_b(this.count);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = buf.readBoolean();
        }
        this.useCount = buf.readBoolean();
        this.count = buf.func_150792_a();
    }
}

