/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPneumaticKick {
    public PacketPneumaticKick() {
    }

    public PacketPneumaticKick(PacketBuffer buffer) {
    }

    public void toBytes(PacketBuffer buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int upgrades;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
            if (handler.upgradeUsable(ArmorUpgradeRegistry.getInstance().kickHandler, false) && (upgrades = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.DISPENSER)) > 0) {
                this.handleKick((PlayerEntity)player, Math.min(4, upgrades));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleKick(PlayerEntity player, int upgrades) {
        Vector3d lookVec = new Vector3d(player.func_70040_Z().field_72450_a, Math.max(0.0, player.func_70040_Z().field_72448_b), player.func_70040_Z().field_72449_c).func_72432_b();
        double playerFootY = player.func_226278_cu_() - (double)(player.func_213302_cg() / 2.0f);
        AxisAlignedBB box = new AxisAlignedBB(player.func_226277_ct_(), playerFootY, player.func_226281_cx_(), player.func_226277_ct_(), playerFootY, player.func_226281_cx_()).func_72314_b(1.5, 1.5, 1.5).func_191194_a(lookVec);
        List entities = player.field_70170_p.func_72839_b((Entity)player, box);
        if (entities.isEmpty()) {
            return;
        }
        entities.sort(Comparator.comparingDouble(o -> o.func_70068_e((Entity)player)));
        Entity target = (Entity)entities.get(0);
        if (!target.func_85031_j((Entity)player)) {
            if (target instanceof LivingEntity) {
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 3.0f + (float)upgrades * 0.5f);
                ((LivingEntity)target).func_70637_d(true);
            }
            target.func_230245_c_(false);
            target.field_70123_F = false;
            target.field_70124_G = false;
            target.func_213317_d(target.func_213322_ci().func_178787_e(lookVec.func_186678_a(1.0 + (double)upgrades * 0.5)).func_72441_c(0.0, (double)upgrades * 0.1, 0.0));
        }
        player.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)ModSounds.PUNCH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        NetworkHandler.sendToAllTracking((Object)new PacketSetEntityMotion(target, target.func_213322_ci()), target);
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((IParticleData)ParticleTypes.field_197627_t, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0, 0.0, 0.0), target);
        CommonArmorHandler.getHandlerForPlayer(player).addAir(EquipmentSlotType.FEET, -150 * upgrades);
    }
}

