/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketJetBootsActivate {
    private final boolean state;

    public PacketJetBootsActivate(boolean state) {
        this.state = state;
    }

    PacketJetBootsActivate(PacketBuffer buffer) {
        this.state = buffer.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.state);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            if (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, EquipmentSlotType.FEET)) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
                JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker((PlayerEntity)player).getJetBootsState((PlayerEntity)player);
                if (handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) > 0 && (!this.state || jbState.isEnabled())) {
                    ArmorUpgradeRegistry.getInstance().jetBootsHandler.setJetBootsActive(handler, this.state);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

