/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemJackHammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemDrillBit
extends Item
implements ColorHandlers.ITintableItem {
    private final DrillBitType type;

    public ItemDrillBit(DrillBitType type) {
        super(ModItems.defaultProps().func_200917_a(1));
        this.type = type;
    }

    public DrillBitType getType() {
        return this.type;
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return this.type.getTint();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.tier", new Object[0]).func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.getType().tier)).func_240699_a_(TextFormatting.GOLD)));
        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.blocks", new Object[0]).func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.getType().getBestDigType().getBlocksDug())).func_240699_a_(TextFormatting.GOLD)));
        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.speed", new Object[0]).func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.getType().baseEfficiency)).func_240699_a_(TextFormatting.GOLD)));
    }

    public static enum DrillBitType {
        NONE("none", 0, 0, 1, -1),
        IRON("iron", 1, -2565928, 6, 2),
        COMPRESSED_IRON("compressed_iron", 2, -7829368, 7, 2),
        DIAMOND("diamond", 3, -13908052, 8, 3),
        NETHERITE("netherite", 4, -11916992, 9, 4);

        private final String name;
        private final int tier;
        private final int tint;
        private final int baseEfficiency;
        private final int harvestLevel;

        private DrillBitType(String name, int tier, int tint, int baseEfficiency, int harvestLevel) {
            this.name = name;
            this.tier = tier;
            this.tint = tint;
            this.baseEfficiency = baseEfficiency;
            this.harvestLevel = harvestLevel;
        }

        public int getTier() {
            return this.tier;
        }

        public int getTint() {
            return this.tint;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public String getRegistryName() {
            return "drill_bit_" + this.name;
        }

        public int getBaseEfficiency() {
            return this.baseEfficiency;
        }

        public ItemStack asItemStack() {
            return this == NONE ? ItemStack.field_190927_a : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(PneumaticRegistry.RL(this.getRegistryName())));
        }

        public ItemJackHammer.DigMode getBestDigType() {
            ItemJackHammer.DigMode best = ItemJackHammer.DigMode.MODE_1X1;
            for (ItemJackHammer.DigMode dt : ItemJackHammer.DigMode.values()) {
                if (dt.getBitType().getTier() > this.getTier()) {
                    return best;
                }
                best = dt;
            }
            return ItemJackHammer.DigMode.MODE_VEIN_PLUS;
        }
    }
}

