/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HeatExchangerLogicTicking
implements IHeatExchangerLogic {
    private final Set<IHeatExchangerLogic> hullExchangers = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<IHeatExchangerLogic> connectedExchangers = Collections.newSetFromMap(new IdentityHashMap());
    private List<HeatBehaviour<?>> behaviours = new ArrayList();
    private List<HeatBehaviour<?>> newBehaviours;
    private double ambientTemperature = -1.0;
    private double temperature = 300.0;
    @GuiSynced
    private int temperatureInt = 300;
    private double thermalResistance = 1.0;
    private double thermalCapacity = 1.0;
    private final BitSet connections = new BitSet(6);

    @Override
    public void initializeAsHull(World world, BlockPos pos, BiPredicate<IWorld, BlockPos> blockFilter, Direction ... validSides) {
        if (this.ambientTemperature < 0.0) {
            this.initializeAmbientTemperature(world, pos);
        }
        if (world.field_72995_K) {
            return;
        }
        for (IHeatExchangerLogic logic2 : this.hullExchangers) {
            this.removeConnectedExchanger(logic2);
        }
        this.hullExchangers.clear();
        this.newBehaviours = new ArrayList();
        this.connections.clear();
        for (Direction dir : validSides) {
            if (HeatBehaviourManager.getInstance().addHeatBehaviours(world, pos.func_177972_a(dir), dir, blockFilter, this, this.newBehaviours) > 0) {
                this.connections.set(dir.func_176745_a());
            }
            HeatExchangerManager.getInstance().getLogic(world, pos.func_177972_a(dir), dir.func_176734_d(), blockFilter).ifPresent(logic -> {
                this.hullExchangers.add((IHeatExchangerLogic)logic);
                this.addConnectedExchanger((IHeatExchangerLogic)logic);
                this.connections.set(dir.func_176745_a());
            });
        }
    }

    @Override
    public boolean isSideConnected(Direction side) {
        return this.connections.get(side.func_176745_a());
    }

    @Override
    public void addConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
        this.connectedExchangers.add(exchanger);
        if (reciprocate) {
            exchanger.addConnectedExchanger(this, false);
        }
    }

    @Override
    public void removeConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
        this.connectedExchangers.remove(exchanger);
        if (reciprocate) {
            exchanger.removeConnectedExchanger(this, false);
        }
    }

    @Override
    public void initializeAmbientTemperature(World world, BlockPos pos) {
        this.ambientTemperature = HeatExchangerLogicAmbient.atPosition((IWorld)world, pos).getAmbientTemperature();
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public int getTemperatureAsInt() {
        return this.temperatureInt;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
        this.temperatureInt = (int)temperature;
    }

    @Override
    public void setThermalResistance(double thermalResistance) {
        this.thermalResistance = thermalResistance;
    }

    @Override
    public double getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public void setThermalCapacity(double capacity) {
        this.thermalCapacity = capacity;
    }

    @Override
    public double getThermalCapacity() {
        return this.thermalCapacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("temperature", this.temperature);
        ListNBT tagList = new ListNBT();
        for (HeatBehaviour<?> behaviour : this.behaviours) {
            CompoundNBT t = behaviour.serializeNBT();
            t.func_74778_a("id", behaviour.getId().toString());
            tagList.add((Object)t);
        }
        tag.func_218657_a("behaviours", (INBT)tagList);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.temperature = nbt.func_74769_h("temperature");
        this.temperatureInt = (int)this.temperature;
        this.behaviours.clear();
        ListNBT tagList = nbt.func_150295_c("behaviours", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT t = tagList.func_150305_b(i);
            Object behaviour = HeatBehaviourManager.getInstance().createBehaviour(new ResourceLocation(t.func_74779_i("id")));
            if (behaviour == null) continue;
            ((HeatBehaviour)behaviour).deserializeNBT(t);
            this.behaviours.add((HeatBehaviour<?>)behaviour);
        }
    }

    @Override
    public void tick() {
        this.temperatureInt = (int)this.temperature;
        if (this.getThermalCapacity() < 0.1) {
            this.setTemperature(this.ambientTemperature);
            return;
        }
        if (this.newBehaviours != null) {
            List<HeatBehaviour<?>> oldBehaviours = this.behaviours;
            this.behaviours = this.newBehaviours;
            this.newBehaviours = null;
            for (HeatBehaviour heatBehaviour : oldBehaviours) {
                int equalBehaviourIndex = this.behaviours.indexOf(heatBehaviour);
                if (equalBehaviourIndex < 0) continue;
                this.behaviours.get(equalBehaviourIndex).deserializeNBT(heatBehaviour.serializeNBT());
            }
        }
        Iterator<HeatBehaviour<?>> iterator = this.behaviours.iterator();
        while (iterator.hasNext()) {
            HeatBehaviour<?> behaviour = iterator.next();
            if (behaviour.getWorld() == null) continue;
            if (behaviour.isApplicable()) {
                behaviour.tick();
                continue;
            }
            iterator.remove();
        }
        for (IHeatExchangerLogic iHeatExchangerLogic : this.connectedExchangers) {
            HeatExchangerLogicTicking.exchange(iHeatExchangerLogic, this, this.getTickingHeatExchangers());
        }
    }

    @Override
    public double getAmbientTemperature() {
        return this.ambientTemperature;
    }

    public static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2) {
        HeatExchangerLogicTicking.exchange(logic, logic2, 1.0);
    }

    private static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2, double dispersionDivider) {
        if (logic.getThermalCapacity() < 0.1) {
            logic.setTemperature(logic.getAmbientTemperature());
            return;
        }
        double deltaTemp = logic.getTemperature() - logic2.getTemperature();
        double totalResistance = logic2.getThermalResistance() + logic.getThermalResistance();
        deltaTemp /= dispersionDivider;
        deltaTemp /= totalResistance;
        double maxDeltaTemp = (logic.getTemperature() * logic.getThermalCapacity() - logic2.getTemperature() * logic2.getThermalCapacity()) / 2.0;
        if (maxDeltaTemp >= 0.0 && deltaTemp > maxDeltaTemp || maxDeltaTemp <= 0.0 && deltaTemp < maxDeltaTemp) {
            deltaTemp = maxDeltaTemp;
        }
        logic2.addHeat(deltaTemp);
        logic.addHeat(-deltaTemp);
    }

    private int getTickingHeatExchangers() {
        int tickingHeatExchangers = 1;
        for (IHeatExchangerLogic logic : this.connectedExchangers) {
            if (!(logic instanceof HeatExchangerLogicTicking)) continue;
            ++tickingHeatExchangers;
        }
        return tickingHeatExchangers;
    }

    @Override
    public void addHeat(double amount) {
        this.setTemperature(MathHelper.func_151237_a((double)(this.temperature + amount / this.getThermalCapacity()), (double)0.0, (double)2273.0));
    }

    @Override
    public <T extends HeatBehaviour<?>> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
        for (HeatBehaviour<?> behaviour : this.behaviours) {
            if (!behaviour.getPos().equals((Object)pos) || !cls.isAssignableFrom(behaviour.getClass())) continue;
            return Optional.of(cls.cast(behaviour));
        }
        return Optional.empty();
    }
}

