/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class HackableEnderman
implements IHackableEntity {
    @Override
    public ResourceLocation getHackableId() {
        return PneumaticRegistry.RL("enderman");
    }

    @Override
    public boolean canHack(Entity entity, PlayerEntity player) {
        return entity instanceof EndermanEntity && HackableEnderman.canEndermanTeleport((LivingEntity)((EndermanEntity)entity));
    }

    @Override
    public void addHackInfo(Entity entity, List<ITextComponent> curInfo, PlayerEntity player) {
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.stopTeleport", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Entity entity, List<ITextComponent> curInfo, PlayerEntity player) {
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.stopTeleporting", new Object[0]));
    }

    @Override
    public int getHackTime(Entity entity, PlayerEntity player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, PlayerEntity player) {
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return entity.func_70089_S();
    }

    private static boolean canEndermanTeleport(LivingEntity entity) {
        List<IHackableEntity> hacks = PneumaticRegistry.getInstance().getHelmetRegistry().getCurrentEntityHacks((Entity)entity);
        return hacks.stream().noneMatch(hack -> hack instanceof HackableEnderman);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEnderTeleport(EntityTeleportEvent.EnderEntity event) {
            LivingEntity e = event.getEntityLiving();
            if (e instanceof EndermanEntity && !HackableEnderman.canEndermanTeleport(e)) {
                event.setCanceled(true);
            }
        }
    }
}

