/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DroneSpecialVariableHandler {
    private static final Map<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>> DISPATCH_MAP = new HashMap<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>>();
    private static final BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> MISSING = (event, extraParam) -> BlockPos.field_177992_a;

    private static void register(String var, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> func) {
        if (DISPATCH_MAP.containsKey(var)) {
            Log.warning("special variable '%s' is already registered! ignoring", new Object[0]);
        } else {
            DISPATCH_MAP.put(var, func);
        }
    }

    @SubscribeEvent
    public void onSpecialVariableRetrieving(SpecialVariableRetrievalEvent.CoordinateVariable.Drone event) {
        String[] s = event.specialVarName.split("=", 2);
        String extra = s.length > 1 ? s[1] : "";
        event.setCoordinate(DISPATCH_MAP.getOrDefault(s[0], MISSING).apply(event, extra));
    }

    private static BlockPos getPosForPlayer(PlayerEntity player) {
        return player == null ? BlockPos.field_177992_a : player.func_233580_cy_().func_177972_a(Direction.UP);
    }

    private static BlockPos getPlayerLookVec(PlayerEntity player) {
        if (player == null) {
            return BlockPos.field_177992_a;
        }
        Direction d = player.func_174811_aO();
        float pitch = player.func_195050_f(0.0f);
        int yDir = Math.abs(pitch) < 45.0f ? 0 : (int)Math.signum(-pitch);
        return new BlockPos(d.func_82601_c(), yDir, d.func_82599_e());
    }

    static {
        DroneSpecialVariableHandler.register("drone_pos", (event, extra) -> new BlockPos(event.drone.getDronePos()));
        DroneSpecialVariableHandler.register("controller_pos", (event, extra) -> event.drone.getControllerPos());
        DroneSpecialVariableHandler.register("owner_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("deploy_pos", (event, extra) -> event.drone.getDeployPos());
        DroneSpecialVariableHandler.register("owner_look", (event, extra) -> DroneSpecialVariableHandler.getPlayerLookVec(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("owner", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("drone", (event, extra) -> new BlockPos(event.drone.getDronePos()).func_177972_a(Direction.UP));
    }
}

