/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class BasicAirHandler
implements IAirHandler,
INBTSerializable<CompoundNBT> {
    @GuiSynced
    private int baseVolume;
    @GuiSynced
    private int airAmount;

    public BasicAirHandler(int volume) {
        this.baseVolume = volume;
        this.airAmount = 0;
    }

    @Override
    public float getPressure() {
        return (float)this.airAmount / (float)this.getVolume();
    }

    @Override
    public int getAir() {
        return this.airAmount;
    }

    @Override
    public void addAir(int amount) {
        this.airAmount = Math.max(this.airAmount + amount, -this.getVolume());
    }

    @Override
    public int getBaseVolume() {
        return this.baseVolume;
    }

    @Override
    public void setBaseVolume(int baseVolume) {
        this.baseVolume = baseVolume;
    }

    @Override
    public int getVolume() {
        return this.baseVolume;
    }

    @Override
    public float maxPressure() {
        return 10.0f;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Air", this.getAir());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.airAmount = nbt.func_74762_e("Air");
    }
}

