/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.tileentity.TileEntityKeroseneLamp;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BlockKeroseneLamp
extends BlockPneumaticCraft {
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)10.0, (double)11.0);
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)10.0, (double)13.0);
    public static final EnumProperty<Direction> CONNECTED = EnumProperty.func_177709_a((String)"connected", Direction.class);
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");

    public BlockKeroseneLamp() {
        super(ModBlocks.defaultProps().func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.getRotation(state).func_176740_k() == Direction.Axis.Z ? SHAPE_NS : SHAPE_EW;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{CONNECTED, LIT});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        return state == null ? null : (BlockState)state.func_206870_a(CONNECTED, (Comparable)this.getConnectedDirection((IWorld)ctx.func_195991_k(), ctx.func_195995_a()));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.func_206870_a(CONNECTED, (Comparable)this.getConnectedDirection(worldIn, currentPos));
    }

    private Direction getConnectedDirection(IWorld world, BlockPos pos) {
        Direction connectedDir = Direction.DOWN;
        for (Direction d : DirectionUtil.VALUES) {
            BlockPos neighborPos = pos.func_177972_a(d);
            if (!Block.func_220055_a((IWorldReader)world, (BlockPos)neighborPos, (Direction)d.func_176734_d())) continue;
            connectedDir = d;
            break;
        }
        return connectedDir;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityKeroseneLamp.class;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    public static class ItemBlockKeroseneLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemBlockKeroseneLamp(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return (Boolean)ConfigHelper.common().machines.keroseneLampCanUseAnyFuel.get() != false ? this.func_77658_a() : this.func_77658_a() + ".kerosene_only";
        }
    }
}

