/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityHeatSink;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockHeatSink
extends BlockPneumaticCraft
implements ColorHandlers.IHeatTintable {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public BlockHeatSink() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityHeatSink.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPES[this.getRotation(state).func_176745_a()];
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        return state == null ? null : (BlockState)state.func_206870_a((Property)this.directionProperty(), (Comparable)ctx.func_196000_l().func_176734_d());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityHeatSink.class).ifPresent(te -> {
            double temp = te.getHeatExchanger().getTemperature();
            if (temp > 333.0) {
                entity.func_70097_a(DamageSource.field_190095_e, 1.0f + ((float)temp - 333.0f) * 0.05f);
                if (temp > 373.0) {
                    entity.func_70015_d(3);
                }
            } else if (temp < 243.0) {
                int durationTicks = (int)((243.0 - temp) * 2.0);
                int amplifier = (int)((243.0 - temp) / 20.0);
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, durationTicks, amplifier));
                if (temp < 213.0) {
                    entity.func_70097_a(DamageSourcePneumaticCraft.FREEZING, 2.0f);
                }
            }
        });
    }
}

