/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetBlockRightClick;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIRightClickBlock
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();
    private final IBlockRightClicker.RightClickType clickType;

    public DroneAIRightClickBlock(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        if (!(widget instanceof IBlockRightClicker)) {
            throw new IllegalArgumentException("expecting a widget implementing IBlockRightClicker!");
        }
        drone.getFakePlayer().func_226284_e_(((IBlockRightClicker)((Object)widget)).isSneaking());
        this.clickType = ((IBlockRightClicker)((Object)widget)).getClickType();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.visitedPositions.contains(pos)) {
            return false;
        }
        if (this.progWidget.isItemFilterEmpty()) {
            return true;
        }
        switch (this.clickType) {
            case CLICK_ITEM: {
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
                    return true;
                }
                return false;
            }
            case CLICK_BLOCK: {
                return DroneAIDig.isBlockValidForFilter((IBlockReader)this.drone.world(), pos, this.drone, this.progWidget);
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        this.visitedPositions.add(pos);
        if (this.rightClick(pos)) {
            if (this.drone.getFakePlayer().func_184614_ca().func_190916_E() <= 0) {
                this.drone.getFakePlayer().func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            this.drone.getInv().setStackInSlot(0, this.drone.getFakePlayer().func_184614_ca());
            this.drone.getDroneItemHandler().copyFromFakePlayer();
        }
        return false;
    }

    private boolean rightClick(BlockPos pos) {
        if (this.clickType == IBlockRightClicker.RightClickType.CLICK_ITEM) {
            return this.rightClickItem(this.drone.getFakePlayer(), pos);
        }
        return this.rightClickBlock(this.drone.getFakePlayer(), pos);
    }

    private boolean rightClickItem(FakePlayer fakePlayer, BlockPos pos) {
        if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(0)) && !this.trySwapItem()) {
            return false;
        }
        ItemStack stack = fakePlayer.func_184614_ca();
        World world = fakePlayer.func_130014_f_();
        try {
            Block block;
            BlockRayTraceResult brtr = this.doTrace(world, pos, fakePlayer);
            if (brtr == null) {
                return false;
            }
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (BlockRayTraceResult)brtr);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return false;
            }
            ActionResultType ret = stack.onItemUseFirst(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
            if (ret != ActionResultType.PASS) {
                return ret.func_226246_a_();
            }
            if (stack.func_190926_b() || fakePlayer.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return false;
            }
            if (stack.func_77973_b() instanceof BlockItem && ((block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof CommandBlockBlock || block instanceof StructureBlock)) {
                return false;
            }
            if (event.getUseItem() != Event.Result.DENY) {
                ItemStack copyBeforeUse = stack.func_77946_l();
                ActionResultType result = stack.func_196084_a(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
                if (result == ActionResultType.PASS) {
                    ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND);
                    fakePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
                }
                if (fakePlayer.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)fakePlayer, (ItemStack)copyBeforeUse, (Hand)Hand.MAIN_HAND);
                }
                return true;
            }
        }
        catch (Throwable e) {
            Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
            e.printStackTrace();
        }
        return false;
    }

    private boolean rightClickBlock(FakePlayer fakePlayer, BlockPos pos) {
        World world = fakePlayer.func_130014_f_();
        BlockState state = world.func_180495_p(pos);
        BlockRayTraceResult brtr = this.doTrace(world, pos, fakePlayer);
        if (brtr != null) {
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (BlockRayTraceResult)brtr);
            try {
                ActionResultType res;
                if (!event.isCanceled() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY && (res = state.func_227031_a_(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr)).func_226246_a_()) {
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
            }
            catch (Throwable e) {
                Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean trySwapItem() {
        for (int i = 1; i < this.drone.getInv().getSlots(); ++i) {
            if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
            ItemStack tmp = this.drone.getInv().getStackInSlot(i);
            this.drone.getInv().setStackInSlot(i, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, tmp);
            return true;
        }
        return false;
    }

    private BlockRayTraceResult doTrace(World world, BlockPos pos, FakePlayer fakePlayer) {
        BlockState state = world.func_180495_p(pos);
        List l = state.func_196954_c((IBlockReader)world, pos).func_197756_d();
        Vector3d targetVec = l.isEmpty() ? Vector3d.func_237489_a_((Vector3i)pos) : ((AxisAlignedBB)l.get(0)).func_189972_c().func_178787_e(Vector3d.func_237491_b_((Vector3i)pos));
        Direction side = ((ProgWidgetBlockRightClick)this.progWidget).getClickSide();
        Vector3d saved = new Vector3d(fakePlayer.func_226277_ct_(), fakePlayer.func_226278_cu_(), fakePlayer.func_226281_cx_());
        Vector3d posVec = targetVec.func_72441_c((double)side.func_82601_c(), (double)side.func_96559_d(), (double)side.func_82599_e());
        fakePlayer.func_70107_b(posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c);
        fakePlayer.func_200602_a(EntityAnchorArgument.Type.FEET, targetVec);
        BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(posVec, targetVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)fakePlayer));
        fakePlayer.func_70107_b(saved.field_72450_a, saved.field_72448_b, saved.field_72449_c);
        if (!brtr.func_216350_a().equals((Object)pos) || brtr.func_216354_b() != side) {
            return null;
        }
        return brtr;
    }
}

