/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.ChestplateLauncherOptions;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChestplateLauncherHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public class ChestplateLauncherClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<ChestplateLauncherHandler> {
    public static final int MAX_PROGRESS = 15;
    private int launcherProgress = 0;

    public ChestplateLauncherClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().chestplateLauncherHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new ChestplateLauncherOptions(screen, this);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public Optional<KeyBinding> getTriggerKeyBinding() {
        return Optional.of(KeyHandler.getInstance().keybindLauncher);
    }

    @Override
    public void onTriggered(ICommonArmorHandler armorHandler) {
        if (!armorHandler.getPlayer().func_184592_cb().func_190926_b() && this.launcherProgress == 0 && armorHandler.upgradeUsable((IArmorUpgradeHandler<?>)this.getCommonHandler(), false)) {
            this.launcherProgress = 1;
        }
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        if (this.launcherProgress > 0) {
            if (!KeyHandler.getInstance().keybindLauncher.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketChestplateLauncher((float)this.launcherProgress / 15.0f));
                this.launcherProgress = 0;
            } else {
                this.launcherProgress = Math.min(this.launcherProgress + 1, 15);
            }
        }
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
        if (this.launcherProgress == 0) {
            return;
        }
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        matrixStack.func_227860_a_();
        RenderSystem.disableTexture();
        if (Minecraft.func_71410_x().field_71439_g.func_184591_cq() == HandSide.LEFT) {
            matrixStack.func_227861_a_((double)(mw.func_198107_o() - 30), (double)(mw.func_198087_p() - 30), -90.0);
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
        } else {
            matrixStack.func_227861_a_(30.0, (double)(mw.func_198087_p() - 30), -90.0);
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-60.0f));
        float progress = Math.min(100.0f, ((float)this.launcherProgress + partialTicks) * 100.0f / 15.0f);
        RenderProgressBar.render2d(matrixStack, 0.0f, 0.0f, (float)mw.func_198107_o() / 6.0f - 30.0f, 12.0f, 0.0f, progress, -1442840416, -1438605057);
        RenderSystem.enableTexture();
        matrixStack.func_227865_b_();
    }
}

