/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetOptionBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiProgWidgetLiquidFilter
extends GuiProgWidgetOptionBase<ProgWidgetLiquidFilter> {
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 6;
    private WidgetFluidFilter mainFilter;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetTextField searchField;
    private int lastScroll;
    private final List<WidgetFluidFilter> visibleFluidWidgets = new ArrayList<WidgetFluidFilter>();
    private int textTimer = 0;

    public GuiProgWidgetLiquidFilter(ProgWidgetLiquidFilter widget, GuiProgrammer guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 176;
        this.ySize = 166;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_ITEM_SEARCHER;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.mainFilter = new WidgetFluidFilter(this.guiLeft + 148, this.guiTop + 12, ((ProgWidgetLiquidFilter)this.progWidget).getFluid(), b -> {
            b.setFluid(Fluids.field_204541_a);
            ((ProgWidgetLiquidFilter)this.progWidget).setFluid(Fluids.field_204541_a);
        });
        this.func_230480_a_(this.mainFilter);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                WidgetFluidFilter f = new WidgetFluidFilter(this.guiLeft + 8 + x * 18, this.guiTop + 52 + y * 18, Fluids.field_204541_a, b -> {
                    this.mainFilter.setFluid(b.getFluid());
                    ((ProgWidgetLiquidFilter)this.progWidget).setFluid(b.getFluid());
                });
                this.func_230480_a_(f);
                this.visibleFluidWidgets.add(f);
            }
        }
        this.searchField = new WidgetTextField(this.field_230712_o_, this.guiLeft + 8, this.guiTop + 35, 90, 10);
        this.func_230480_a_(this.searchField);
        this.func_231035_a_((IGuiEventListener)this.searchField);
        this.searchField.func_146195_b(true);
        this.searchField.func_212954_a(s -> {
            this.textTimer = 5;
        });
        this.scrollbar = new WidgetVerticalScrollbar(this.guiLeft + 155, this.guiTop + 47, 112);
        this.scrollbar.setListening(true);
        this.func_230480_a_(this.scrollbar);
        this.addValidFluids();
    }

    private void addValidFluids() {
        List fluids = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> this.matchSearch(this.searchField.func_146179_b(), (Fluid)fluid)).sorted(Comparator.comparing(f -> new FluidStack(f, 1).getDisplayName().getString())).collect(Collectors.toList());
        this.scrollbar.setStates(Math.max(0, (fluids.size() - 48 + 8 - 1) / 8));
        int offset = this.scrollbar.getState() * 8;
        for (int i = 0; i < this.visibleFluidWidgets.size(); ++i) {
            if (i + offset < fluids.size()) {
                this.visibleFluidWidgets.get(i).setFluid((Fluid)fluids.get(i + offset));
                continue;
            }
            this.visibleFluidWidgets.get(i).setFluid(Fluids.field_204541_a);
        }
    }

    private boolean matchSearch(String srch, Fluid fluid) {
        if (fluid == Fluids.field_204541_a || !fluid.func_207193_c(fluid.func_207188_f())) {
            return false;
        }
        String srchL = srch.toLowerCase();
        return srch.isEmpty() || new FluidStack(fluid, 1).getDisplayName().getString().toLowerCase().contains(srchL);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.lastScroll != this.scrollbar.getState()) {
            this.lastScroll = this.scrollbar.getState();
            this.addValidFluids();
        } else if (this.textTimer > 0 && --this.textTimer == 0) {
            this.addValidFluids();
        }
    }
}

