/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.settings.KeyModifier;

public class KeybindingButton
extends WidgetButtonExtended
implements IKeybindingButton {
    private final KeyBinding keyBinding;
    private final ITextComponent origButtonText;
    private boolean bindingMode = false;
    private boolean modifier = false;
    private Action action = Action.NONE;

    public KeybindingButton(int startX, int startY, int xSize, int ySize, ITextComponent buttonText, KeyBinding keyBinding) {
        super(startX, startY, xSize, ySize, buttonText);
        this.keyBinding = keyBinding;
        this.origButtonText = buttonText;
        this.addTooltip();
    }

    private void addTooltip() {
        this.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(this.keyBinding)));
    }

    @Override
    public void func_230930_b_() {
        if (this.bindingMode) {
            if (!this.modifier) {
                this.setBindingMode(false);
            }
        } else {
            this.setBindingMode(true);
        }
    }

    private void setBindingMode(boolean newMode) {
        this.bindingMode = newMode;
        if (this.bindingMode) {
            this.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
            this.setTooltipText(StringTextComponent.field_240750_d_);
        } else {
            this.func_238482_a_(this.origButtonText);
            this.addTooltip();
            switch (this.action) {
                case ADD: {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_193808_ex, 1.0f, 1.0f);
                    break;
                }
                case REMOVE: {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                }
            }
            this.action = Action.NONE;
        }
    }

    @Override
    public boolean receiveKey(InputMappings.Type type, int keyCode) {
        if (this.bindingMode) {
            if (type == InputMappings.Type.KEYSYM && keyCode == 256) {
                this.keyBinding.setKeyModifierAndCode(KeyModifier.NONE, InputMappings.field_197958_a);
                Minecraft.func_71410_x().field_71474_y.func_198014_a(this.keyBinding, InputMappings.field_197958_a);
                this.action = Action.REMOVE;
            } else {
                InputMappings.Input input = type.func_197944_a(keyCode);
                this.modifier = KeyModifier.isKeyCodeModifier((InputMappings.Input)input);
                this.keyBinding.setKeyModifierAndCode(KeyModifier.getActiveModifier(), input);
                Minecraft.func_71410_x().field_71474_y.func_198014_a(this.keyBinding, input);
                this.action = Action.ADD;
            }
            KeyBinding.func_74508_b();
            this.func_230930_b_();
            return true;
        }
        return false;
    }

    @Override
    public void receiveKeyReleased() {
        this.setBindingMode(false);
    }

    private static enum Action {
        NONE,
        ADD,
        REMOVE;

    }
}

