/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import java.util.Optional;
import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public interface IHeatExchangerLogic
extends INBTSerializable<CompoundNBT> {
    public static final BiPredicate<IWorld, BlockPos> ALL_BLOCKS = (world, pos) -> true;

    public void tick();

    public void initializeAsHull(World var1, BlockPos var2, BiPredicate<IWorld, BlockPos> var3, Direction ... var4);

    public void initializeAmbientTemperature(World var1, BlockPos var2);

    default public void addConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.addConnectedExchanger(exchanger, true);
    }

    default public void addConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
    }

    default public void removeConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.removeConnectedExchanger(exchanger, true);
    }

    default public void removeConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
    }

    public void setTemperature(double var1);

    public double getTemperature();

    public int getTemperatureAsInt();

    public double getAmbientTemperature();

    public void setThermalResistance(double var1);

    public double getThermalResistance();

    public void setThermalCapacity(double var1);

    public double getThermalCapacity();

    public void addHeat(double var1);

    public boolean isSideConnected(Direction var1);

    default public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    default public void deserializeNBT(CompoundNBT nbt) {
    }

    default public <T extends HeatBehaviour<?>> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
        return Optional.empty();
    }
}

