/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.harvesting;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class HarvestHandler
extends ForgeRegistryEntry<HarvestHandler> {
    public void harvest(World world, IBlockReader chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        world.func_175655_b(pos, true);
    }

    public boolean harvestAndReplant(World world, IBlockReader chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        this.harvest(world, chunkCache, pos, state, drone);
        return false;
    }

    public abstract boolean canHarvest(World var1, IBlockReader var2, BlockPos var3, BlockState var4, IDrone var5);

    public List<ItemStack> addFilterItems(World world, IBlockReader chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        return world instanceof ServerWorld ? Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos)) : Collections.emptyList();
    }

    public static class SimpleHarvestHandler
    extends HarvestHandler {
        private final Set<Block> blocks;

        public SimpleHarvestHandler(Block ... blocks) {
            this.blocks = Sets.newHashSet((Object[])blocks);
        }

        @Override
        public boolean canHarvest(World world, IBlockReader chunkCache, BlockPos pos, BlockState state, IDrone drone) {
            return this.blocks.contains(state.func_177230_c());
        }
    }
}

