/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.client.pneumatic_helmet;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface IOptionPage {
    public IGuiScreen getGuiScreen();

    public IFormattableTextComponent getPageName();

    public void populateGui(IGuiScreen var1);

    public void renderPre(MatrixStack var1, int var2, int var3, float var4);

    public void renderPost(MatrixStack var1, int var2, int var3, float var4);

    public boolean keyPressed(int var1, int var2, int var3);

    public boolean keyReleased(int var1, int var2, int var3);

    public boolean mouseClicked(double var1, double var3, int var5);

    public boolean mouseScrolled(double var1, double var3, double var5);

    public boolean mouseDragged(double var1, double var3, int var5, double var6, double var8);

    public boolean isToggleable();

    public boolean displaySettingsHeader();

    default public int settingsYposition() {
        return 115;
    }

    default public void tick() {
    }

    default public Optional<IKeybindingButton> getKeybindingButton() {
        return Optional.empty();
    }

    public static class SimpleOptionPage<T extends IArmorUpgradeClientHandler<?>>
    implements IOptionPage {
        private final IGuiScreen screen;
        private final IFormattableTextComponent name;
        private final T clientUpgradeHandler;

        public SimpleOptionPage(IGuiScreen screen, T clientUpgradeHandler) {
            this.screen = screen;
            this.name = new TranslationTextComponent(IArmorUpgradeHandler.getStringKey(clientUpgradeHandler.getCommonHandler().getID()));
            this.clientUpgradeHandler = clientUpgradeHandler;
        }

        protected T getClientUpgradeHandler() {
            return this.clientUpgradeHandler;
        }

        @Override
        public IGuiScreen getGuiScreen() {
            return this.screen;
        }

        @Override
        public IFormattableTextComponent getPageName() {
            return this.name;
        }

        @Override
        public void populateGui(IGuiScreen gui) {
        }

        @Override
        public void renderPre(MatrixStack matrixStack, int x, int y, float partialTicks) {
        }

        @Override
        public void renderPost(MatrixStack matrixStack, int x, int y, float partialTicks) {
        }

        @Override
        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.getKeybindingButton().map(b -> b.receiveKey(InputMappings.Type.KEYSYM, keyCode)).orElse(false);
        }

        @Override
        public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
            return this.getKeybindingButton().map(b -> {
                b.receiveKeyReleased();
                return true;
            }).orElse(false);
        }

        @Override
        public boolean mouseClicked(double x, double y, int button) {
            return this.getKeybindingButton().map(b -> b.receiveKey(InputMappings.Type.MOUSE, button)).orElse(false);
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return false;
        }

        @Override
        public boolean mouseScrolled(double x, double y, double dir) {
            return false;
        }

        @Override
        public boolean isToggleable() {
            return this.getClientUpgradeHandler().isToggleable();
        }

        @Override
        public boolean displaySettingsHeader() {
            return false;
        }
    }
}

