/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AmountSpecifyingScreen<T extends Container>
extends BaseScreen<T> {
    private final BaseScreen<T> parent;
    protected TextFieldWidget amountField;
    protected Button okButton;
    protected Button cancelButton;

    protected AmountSpecifyingScreen(BaseScreen<T> parent, T container, int width, int height, PlayerInventory playerInventory, ITextComponent title) {
        super(container, width, height, playerInventory, title);
        this.parent = parent;
    }

    protected abstract ITextComponent getOkButtonText();

    protected abstract String getTexture();

    protected abstract int[] getIncrements();

    protected abstract int getDefaultAmount();

    protected abstract boolean canAmountGoNegative();

    protected abstract int getMaxAmount();

    protected Pair<Integer, Integer> getAmountPos() {
        return Pair.of((Object)9, (Object)51);
    }

    protected Pair<Integer, Integer> getOkCancelPos() {
        return Pair.of((Object)114, (Object)33);
    }

    protected int getOkCancelButtonWidth() {
        return 50;
    }

    @Override
    public void onPostInit(int x, int y) {
        StringTextComponent text;
        int increment;
        int i;
        Pair<Integer, Integer> pos = this.getOkCancelPos();
        this.okButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight(), this.getOkCancelButtonWidth(), 20, this.getOkButtonText(), true, true, btn -> this.onOkButtonPressed(AmountSpecifyingScreen.func_231173_s_()));
        this.cancelButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight() + 24, this.getOkCancelButtonWidth(), 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), true, true, btn -> this.close());
        int n = x + (Integer)this.getAmountPos().getLeft();
        int n2 = y + (Integer)this.getAmountPos().getRight();
        this.field_230712_o_.getClass();
        this.amountField = new TextFieldWidget(this.field_230712_o_, n, n2, 63, 9, (ITextComponent)new StringTextComponent(""));
        this.amountField.func_146185_a(false);
        this.amountField.func_146189_e(true);
        this.amountField.func_146180_a(String.valueOf(this.getDefaultAmount()));
        this.amountField.func_146193_g(RenderSettings.INSTANCE.getSecondaryColor());
        this.amountField.func_146205_d(false);
        this.amountField.func_231049_c__(true);
        this.func_230480_a_((Widget)this.amountField);
        this.func_231035_a_((IGuiEventListener)this.amountField);
        int[] increments = this.getIncrements();
        int xx = 7;
        int width = 30;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = new StringTextComponent("+" + increment);
            if (text.getString().equals("+1000")) {
                text = new StringTextComponent("+1B");
            }
            this.addButton(x + xx, y + 20, width, 20, (ITextComponent)text, true, true, btn -> this.onIncrementButtonClicked(increment));
            xx += width + 3;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = new StringTextComponent("-" + increment);
            if (text.getString().equals("-1000")) {
                text = new StringTextComponent("-1B");
            }
            this.addButton(x + xx, y + this.field_147000_g - 20 - 7, width, 20, (ITextComponent)text, true, true, btn -> this.onIncrementButtonClicked(-increment));
            xx += width + 3;
        }
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        if ((key == 257 || key == 335) && this.amountField.func_230999_j_()) {
            this.onOkButtonPressed(AmountSpecifyingScreen.func_231173_s_());
            return true;
        }
        if (this.amountField.func_231046_a_(key, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    private void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = increment;
        newAmount = !this.canAmountGoNegative() ? Math.max(1, (oldAmount == 1 && newAmount != 1 ? 0 : oldAmount) + newAmount) : oldAmount + newAmount;
        if (newAmount > this.getMaxAmount()) {
            newAmount = this.getMaxAmount();
        }
        this.amountField.func_146180_a(String.valueOf(newAmount));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", this.getTexture());
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.amountField.func_230431_b_(matrixStack, 0, 0, 0.0f);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
    }

    protected void onOkButtonPressed(boolean shiftDown) {
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        if (delta > 0.0) {
            this.onIncrementButtonClicked(1);
        } else {
            this.onIncrementButtonClicked(-1);
        }
        return super.func_231043_a_(x, y, delta);
    }

    public void close() {
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public BaseScreen<T> getParent() {
        return this.parent;
    }
}

