/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.krate.block.KrateTile;
import owmii.lib.network.IPacket;

public class HopperPacket
implements IPacket<HopperPacket> {
    private BlockPos pos;
    private final Direction side;
    private int mode;

    public HopperPacket(BlockPos pos, Direction side, int mode) {
        this.pos = pos;
        this.side = side;
        this.mode = mode;
    }

    public HopperPacket() {
        this(BlockPos.field_177992_a, Direction.DOWN, 0);
    }

    public void encode(HopperPacket msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.pos);
        buffer.writeInt(msg.side.func_176745_a());
        buffer.writeInt(msg.mode);
    }

    public HopperPacket decode(PacketBuffer buffer) {
        return new HopperPacket(buffer.func_179259_c(), Direction.func_82600_a((int)buffer.readInt()), buffer.readInt());
    }

    public void handle(HopperPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world;
            TileEntity tile;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (tile = (world = player.func_130014_f_()).func_175625_s(msg.pos)) instanceof KrateTile) {
                KrateTile krate = (KrateTile)tile;
                if (msg.mode == 0) {
                    krate.getHopper().switchPush(msg.side);
                } else {
                    krate.getHopper().switchPull(msg.side);
                }
                krate.sync();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

