/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.lib.util.Server;

public class CompactingHandler {
    private static final Map<IItemProvider, ItemStack> CACHE_2X2 = new HashMap<IItemProvider, ItemStack>();
    private static final Map<IItemProvider, ItemStack> CACHE_3X3 = new HashMap<IItemProvider, ItemStack>();
    private static final Set<IItemProvider> CACHE_EMPTY_2X2 = new HashSet<IItemProvider>();
    private static final Set<IItemProvider> CACHE_EMPTY_3X3 = new HashSet<IItemProvider>();

    public static ItemStack get(World world, ItemStack stack, boolean small) {
        if (!stack.func_190926_b()) {
            if (small) {
                if (CACHE_2X2.containsKey(stack.func_77973_b())) {
                    return CACHE_2X2.get(stack.func_77973_b());
                }
                if (CACHE_EMPTY_2X2.contains(stack.func_77973_b())) {
                    return ItemStack.field_190927_a;
                }
                ItemStack resStack = CompactingHandler.result(world, stack, true);
                if (resStack.func_190926_b()) {
                    CACHE_EMPTY_2X2.add((IItemProvider)stack.func_77973_b());
                    return ItemStack.field_190927_a;
                }
                CACHE_2X2.put((IItemProvider)stack.func_77973_b(), resStack.func_77946_l());
                return resStack.func_77946_l();
            }
            if (CACHE_3X3.containsKey(stack.func_77973_b())) {
                return CACHE_3X3.get(stack.func_77973_b());
            }
            if (CACHE_EMPTY_3X3.contains(stack.func_77973_b())) {
                return ItemStack.field_190927_a;
            }
            ItemStack resStack = CompactingHandler.result(world, stack, false);
            if (resStack.func_190926_b()) {
                CACHE_EMPTY_3X3.add((IItemProvider)stack.func_77973_b());
                return ItemStack.field_190927_a;
            }
            CACHE_3X3.put((IItemProvider)stack.func_77973_b(), resStack.func_77946_l());
            return resStack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    static ItemStack result(World world, ItemStack stack, boolean small) {
        if (!world.field_72995_K) {
            CraftingInventory inventory = new CraftingInventory(AbstractContainer.DUMMY, 3, 3);
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (small && (i == 2 || i > 4)) continue;
                inventory.func_70299_a(i, stack.func_77946_l());
            }
            Optional result = Server.get().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (result.isPresent()) {
                return ((ICraftingRecipe)result.get()).func_77571_b();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void clearCache() {
        CACHE_2X2.clear();
        CACHE_3X3.clear();
        CACHE_EMPTY_2X2.clear();
        CACHE_EMPTY_3X3.clear();
    }
}

