/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.client.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import owmii.krate.Krate;
import owmii.krate.block.KrateTile;
import owmii.krate.client.screen.Textures;
import owmii.krate.inventory.KrateContainer;
import owmii.krate.network.packet.CompactingPacket;
import owmii.krate.network.packet.ReqCollectSettingPacket;
import owmii.krate.network.packet.ReqHopperSettingPacket;
import owmii.lib.client.screen.container.AbstractTileScreen;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.logistics.inventory.AbstractTileContainer;

public class KrateScreen
extends AbstractTileScreen<KrateTile, KrateContainer> {
    private final boolean large;
    private IconButton collectButton = IconButton.EMPTY;
    private IconButton hopperButton = IconButton.EMPTY;
    private IconButton compactButton = IconButton.EMPTY;
    public static int prevSide;

    public KrateScreen(KrateContainer container, PlayerInventory inv, ITextComponent title) {
        super((AbstractTileContainer)container, inv, title, Textures.BG_MAP.get(((KrateTile)container.te).getVariant()));
        this.large = container.isLarge();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.collectButton = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + this.field_146999_f, this.field_147009_r + 8, Textures.COLLECT_BTN, button -> Krate.NET.toServer((Object)new ReqCollectSettingPacket(((KrateTile)this.te).func_174877_v())), (Screen)this).setTooltip(tooltip -> tooltip.add(new TranslationTextComponent("gui.krate.collecting.setting").func_240699_a_(TextFormatting.GRAY))));
        this.hopperButton = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + this.field_146999_f, this.field_147009_r + 8, Textures.HOPPER_BTN, button -> Krate.NET.toServer((Object)new ReqHopperSettingPacket(((KrateTile)this.te).func_174877_v(), Direction.func_82600_a((int)prevSide))), (Screen)this).setTooltip(tooltip -> tooltip.add(new TranslationTextComponent("gui.krate.hopper.setting").func_240699_a_(TextFormatting.GRAY))));
        this.compactButton = (IconButton)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + this.field_146999_f, this.field_147009_r + 8, Textures.COMPACT_TAB.get(((KrateTile)this.te).isSmallMatrix()), button -> Krate.NET.toServer((Object)new CompactingPacket(((KrateTile)this.te).func_174877_v())), (Screen)this).setTooltip(tooltip -> tooltip.add(new TranslationTextComponent("gui.krate.compacting.mode").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.krate.compacting.matrix." + (((KrateTile)this.te).isSmallMatrix() ? "small" : "big")).func_240699_a_(TextFormatting.DARK_AQUA)))));
        this.refresh();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.refresh();
    }

    private void refresh() {
        this.collectButton.field_230694_p_ = ((KrateTile)this.te).canCollect();
        this.hopperButton.field_230694_p_ = ((KrateTile)this.te).canTransferItems();
        this.compactButton.field_230694_p_ = ((KrateTile)this.te).canCompact();
        int y = this.collectButton.field_230694_p_ ? 18 : 0;
        this.hopperButton.field_230691_m_ = this.field_147009_r + 8 + y;
        this.compactButton.field_230691_m_ = this.field_147009_r + 8 + (y += this.hopperButton.field_230694_p_ ? 18 : 0);
        this.compactButton.setTexture(Textures.COMPACT_TAB.get(((KrateTile)this.te).isSmallMatrix()));
    }

    protected void drawBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.large) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Textures.KRATE_144_0.draw(matrix, this.field_147003_i, this.field_147009_r);
            Textures.KRATE_144_1.draw(matrix, this.field_147003_i + Textures.KRATE_144_0.getWidth(), this.field_147009_r);
        } else {
            super.drawBackground(matrix, partialTicks, mouseX, mouseY);
        }
        Textures.UP_SLOTS.draw(matrix, this.field_147003_i - 27, this.field_147009_r + 3);
    }

    protected void drawForeground(MatrixStack matrix, int mouseX, int mouseY) {
        String title = this.field_230704_d_.getString();
        int width = this.field_230712_o_.func_78256_a(title);
        this.field_230712_o_.func_238405_a_(matrix, title, (float)(this.field_146999_f / 2 - width / 2), -14.0f, 0x999999);
    }

    protected boolean hasRedstone() {
        return false;
    }
}

