/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.event.ConfigLoadedEvent;
import io.github.noeppi_noeppi.libx.impl.config.ConfigGroup;
import io.github.noeppi_noeppi.libx.impl.config.ConfigKey;
import io.github.noeppi_noeppi.libx.impl.config.ConfigState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ConfigImpl {
    public static final Gson GSON = (Gson)Util.func_199748_a(() -> {
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.disableHtmlEscaping();
        gsonbuilder.setLenient();
        gsonbuilder.setPrettyPrinting();
        return gsonbuilder.create();
    });
    public static final Gson INTERNAL = (Gson)Util.func_199748_a(() -> {
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.disableHtmlEscaping();
        return gsonbuilder.create();
    });
    private static final Map<ResourceLocation, ConfigImpl> configs = Collections.synchronizedMap(new HashMap());
    public final ResourceLocation id;
    public final Class<?> baseClass;
    public final Path path;
    public final Map<Field, ConfigKey> keys;
    public final Set<ConfigGroup> groups;
    public final boolean clientConfig;
    private boolean shadowed;
    private ConfigState savedState;
    private ConfigState defaultState;

    @Nonnull
    public static ConfigImpl getConfig(ResourceLocation id) {
        if (configs.containsKey(id)) {
            return configs.get(id);
        }
        throw new IllegalStateException("Config not registered: " + id);
    }

    @Nullable
    public static ConfigImpl getConfigNullable(ResourceLocation id) {
        return configs.getOrDefault(id, null);
    }

    public ConfigImpl(ResourceLocation id, Class<?> baseClass, Path path, boolean clientConfig) {
        if (configs.containsKey(id)) {
            throw new IllegalStateException("Config registered twice: " + id + " (" + baseClass + ")");
        }
        configs.put(id, this);
        this.id = id;
        this.path = path;
        this.baseClass = baseClass;
        this.clientConfig = clientConfig;
        try {
            ImmutableMap.Builder keys = ImmutableMap.builder();
            ImmutableSet.Builder groups = ImmutableSet.builder();
            ConfigImpl.addAllFieldsToBuilder(baseClass, baseClass, (ImmutableMap.Builder<Field, ConfigKey>)keys, (ImmutableSet.Builder<ConfigGroup>)groups);
            this.keys = keys.build();
            this.groups = groups.build();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to build config for class " + baseClass, e);
        }
        this.shadowed = false;
        this.savedState = null;
        this.defaultState = null;
    }

    public ConfigState stateFromValues() {
        try {
            ImmutableMap.Builder values = ImmutableMap.builder();
            for (ConfigKey key : this.keys.values()) {
                Object value = key.field.get(null);
                if (value == null) {
                    throw new IllegalStateException("Null value in applied config. This is usually an error in the mod.");
                }
                values.put((Object)key, value);
            }
            return new ConfigState(this, (ImmutableMap<ConfigKey, Object>)values.build(), (ImmutableSet<ConfigGroup>)ImmutableSet.copyOf(this.groups));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to read config state from current values.");
        }
    }

    public ConfigState readState(PacketBuffer buffer) {
        try {
            HashSet<ConfigKey> keysLeft = new HashSet<ConfigKey>(this.keys.values());
            ImmutableMap.Builder values = ImmutableMap.builder();
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                ConfigKey key;
                Field field;
                Class<?> declaringClass = Class.forName(buffer.func_150789_c(Short.MAX_VALUE));
                try {
                    field = declaringClass.getDeclaredField(buffer.func_150789_c(Short.MAX_VALUE));
                }
                catch (NoSuchFieldException e) {
                    field = null;
                }
                ResourceLocation mapperId = buffer.func_192575_l();
                String elementTypeStr = buffer.func_150789_c(Short.MAX_VALUE);
                Class<Void> elementType = elementTypeStr.isEmpty() ? Void.TYPE : Class.forName(elementTypeStr);
                ConfigKey configKey = key = field == null ? null : this.keys.get(field);
                if (key == null) {
                    throw new IllegalStateException("Config between client and server mismatch. Server sent unknown or non-config field. Ignoring");
                }
                if (!key.mapperId.equals((Object)mapperId)) {
                    throw new IllegalStateException("Config incompatible. Don't know how to read object: Mapper unknown: Local mapper: " + key.mapperId + ", Remote Mapper: " + mapperId);
                }
                if (!key.elementType.equals(elementType)) {
                    throw new IllegalStateException("Config incompatible. Don't know how to read object: Different element types.");
                }
                Object value = key.mapper.read(buffer, key.elementType);
                values.put((Object)key, value);
                keysLeft.remove(key);
            }
            if (!keysLeft.isEmpty()) {
                LibX.logger.warn("Config " + this.id + ": There are additional fields on the client, not sent by the server. Using client values.");
            }
            return new ConfigState(this, (ImmutableMap<ConfigKey, Object>)values.build(), (ImmutableSet<ConfigGroup>)ImmutableSet.copyOf(this.groups));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to read config state.", e);
        }
    }

    public ConfigState readFromFileOrCreateByDefault() throws IOException {
        if (this.defaultState == null) {
            throw new IllegalStateException("LibX config internal error: Default state not set.");
        }
        return this.readFromFileOrCreateBy(this.defaultState);
    }

    public ConfigState readFromFileOrCreateBy(ConfigState state) throws IOException {
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            LibX.logger.info("Config '" + this.id + "' does not exist. Creating default.");
            state.writeToFile();
            return state;
        }
        return this.readFromFile();
    }

    public ConfigState readFromFile() throws IOException {
        if (this.defaultState == null) {
            throw new IllegalStateException("Can't read config from file: Default state not set.");
        }
        if (!Files.isRegularFile(this.path, new LinkOption[0]) || !Files.isReadable(this.path)) {
            throw new IllegalStateException("Config '" + this.id + "' does not exist or is not readable.");
        }
        BufferedReader reader = Files.newBufferedReader(this.path);
        JsonObject config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        ImmutableMap.Builder values = ImmutableMap.builder();
        AtomicBoolean needsCorrection = new AtomicBoolean(false);
        for (ConfigKey key : this.keys.values()) {
            JsonElement elem = ConfigImpl.getInObjectKeyPath(config, key, needsCorrection);
            if (elem != null && key.mapper.element().isAssignableFrom(elem.getClass())) {
                try {
                    Object value = key.mapper.fromJSON(elem, key.elementType);
                    values.put((Object)key, key.validate(value, "Invalid value in config file", needsCorrection));
                }
                catch (Exception e) {
                    LibX.logger.warn("Failed to read config value " + String.join((CharSequence)".", key.path) + ". Using default. Error: " + e.getMessage());
                    values.put((Object)key, this.defaultState.getValue(key));
                    needsCorrection.set(true);
                }
                continue;
            }
            values.put((Object)key, this.defaultState.getValue(key));
            needsCorrection.set(true);
        }
        ((Reader)reader).close();
        ConfigState state = new ConfigState(this, (ImmutableMap<ConfigKey, Object>)values.build(), (ImmutableSet<ConfigGroup>)ImmutableSet.copyOf(this.groups));
        if (needsCorrection.get()) {
            LibX.logger.info("Correcting config '" + this.id + "'");
            state.writeToFile();
        }
        return state;
    }

    private static void addAllFieldsToBuilder(Class<?> baseClass, Class<?> currentClass, ImmutableMap.Builder<Field, ConfigKey> keys, ImmutableSet.Builder<ConfigGroup> groups) throws ReflectiveOperationException {
        HashSet<String> names = new HashSet<String>();
        for (Field field : currentClass.getDeclaredFields()) {
            ConfigKey key = ConfigKey.create(field, baseClass);
            if (key == null) continue;
            field.setAccessible(true);
            keys.put((Object)field, (Object)key);
            if (names.contains(field.getName())) {
                throw new IllegalStateException("Duplicate key in config definition: " + field.getName());
            }
            names.add(field.getName());
        }
        for (AnnotatedElement annotatedElement : currentClass.getDeclaredClasses()) {
            ConfigGroup group = ConfigGroup.create(annotatedElement, baseClass);
            if (group == null) continue;
            groups.add((Object)group);
            if (names.contains(((Class)annotatedElement).getSimpleName())) {
                throw new IllegalStateException("Duplicate key in config definition: " + ((Class)annotatedElement).getSimpleName());
            }
            names.add(((Class)annotatedElement).getSimpleName());
            ConfigImpl.addAllFieldsToBuilder(baseClass, annotatedElement, keys, groups);
        }
    }

    private static JsonElement getInObjectKeyPath(JsonObject root, ConfigKey key, @Nullable AtomicBoolean needsCorrection) {
        if (key.path.isEmpty()) {
            throw new IllegalStateException("Internal error in LibX config: Empty path for a config key: " + key.field.getName() + " @ " + key.field.getDeclaringClass());
        }
        JsonObject current = root;
        for (int i = 0; i < key.path.size() - 1; ++i) {
            JsonElement elem = current.get(key.path.get(i));
            if (elem == null || !elem.isJsonObject()) {
                if (needsCorrection != null) {
                    needsCorrection.set(true);
                }
                return null;
            }
            current = elem.getAsJsonObject();
        }
        return current.get(key.path.get(key.path.size() - 1));
    }

    public void shadowBy(ConfigState state) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            LibX.logger.error("Config shadow was called on a dedicated server. This should not happen!");
        }
        if (!this.shadowed && this.savedState == null) {
            LibX.logger.warn("Capturing config state for '" + this.id + "' before shadowing. This should not happen. Was the config not loaded properly?");
            this.savedState = this.stateFromValues();
        }
        this.shadowed = true;
        state.apply();
        MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(this.id, this.baseClass, ConfigLoadedEvent.LoadReason.SHADOW, this.clientConfig, this.path));
    }

    public void restore() {
        if (this.shadowed && this.savedState != null) {
            this.savedState.apply();
        } else if (this.shadowed) {
            LibX.logger.warn("Could not restore config: No saved state");
        }
        this.shadowed = false;
        MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(this.id, this.baseClass, ConfigLoadedEvent.LoadReason.RESTORE, this.clientConfig, this.path));
    }

    public void saveState(ConfigState state) {
        this.savedState = state;
    }

    public void setDefaultState(ConfigState defaultState) {
        if (this.defaultState != null) {
            throw new IllegalStateException("Default state set twice.");
        }
        this.defaultState = defaultState;
    }

    public ConfigState cachedOrCurrent() {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            LibX.logger.error("Config cached or current method was called on a physical client. This should not happen!");
        }
        if (this.savedState == null) {
            LibX.logger.warn("Capturing config state for '" + this.id + "' on server. This should not happen. Was the config not loaded properly?");
            this.savedState = this.stateFromValues();
        }
        return this.savedState;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }
}

