/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.data.AlwaysExistentModelFile;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.render.ItemStackRenderer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ItemModelProviderBase
extends ItemModelProvider {
    public static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    public static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");
    public static final ResourceLocation TEISR_PARENT = new ResourceLocation(LibX.getInstance().modid, "item/base/teisr");
    public static final ResourceLocation SPAWN_EGG_PARENT = new ResourceLocation("minecraft", "item/template_spawn_egg");
    protected final ModX mod;
    private final Set<Item> handheld = new HashSet<Item>();
    private final Set<Item> blacklist = new HashSet<Item>();

    public ItemModelProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, mod.modid, fileHelper);
        this.mod = mod;
    }

    @Nonnull
    public final String func_200397_b() {
        return this.mod.modid + " item models";
    }

    protected void handheld(Item item) {
        this.handheld.add(item);
    }

    protected void manualModel(Item item) {
        this.blacklist.add(item);
    }

    protected void registerModels() {
        this.setup();
        for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null || !this.mod.modid.equals(id.func_110624_b()) || this.blacklist.contains(item)) continue;
            if (item instanceof BlockItem) {
                this.defaultBlock(id, (BlockItem)item);
                continue;
            }
            if (this.handheld.contains(item)) {
                ((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), HANDHELD)).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()));
                continue;
            }
            this.defaultItem(id, item);
        }
    }

    protected abstract void setup();

    protected void defaultItem(ResourceLocation id, Item item) {
        if (item instanceof SpawnEggItem) {
            this.withExistingParent(id.func_110623_a(), SPAWN_EGG_PARENT);
        } else {
            ((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), GENERATED)).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()));
        }
    }

    protected void defaultBlock(ResourceLocation id, BlockItem item) {
        if (item.getItemStackTileEntityRenderer() == ItemStackRenderer.get()) {
            ((ItemModelBuilder)this.getBuilder(id.func_110623_a())).parent((ModelFile)new AlwaysExistentModelFile(TEISR_PARENT));
        } else {
            ((ItemModelBuilder)this.getBuilder(id.func_110623_a())).parent((ModelFile)new AlwaysExistentModelFile(new ResourceLocation(id.func_110624_b(), "block/" + id.func_110623_a())));
        }
    }
}

