/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.trashcans.ClientProxy;
import com.supermartijn642.trashcans.TrashCanBlock;
import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.data.TrashCansAdvancementProvider;
import com.supermartijn642.trashcans.filter.FluidFilterManager;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.packet.TrashCanPacket;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.ItemTrashCanContainer;
import com.supermartijn642.trashcans.screen.LiquidTrashCanContainer;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="trashcans")
public class TrashCans {
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trashcans", "main"), () -> "1", "1"::equals, "1"::equals);
    @ObjectHolder(value="trashcans:item_trash_can")
    public static Block item_trash_can;
    @ObjectHolder(value="trashcans:liquid_trash_can")
    public static Block liquid_trash_can;
    @ObjectHolder(value="trashcans:energy_trash_can")
    public static Block energy_trash_can;
    @ObjectHolder(value="trashcans:ultimate_trash_can")
    public static Block ultimate_trash_can;
    @ObjectHolder(value="trashcans:item_trash_can_tile")
    public static TileEntityType<TrashCanTile> item_trash_can_tile;
    @ObjectHolder(value="trashcans:liquid_trash_can_tile")
    public static TileEntityType<TrashCanTile> liquid_trash_can_tile;
    @ObjectHolder(value="trashcans:energy_trash_can_tile")
    public static TileEntityType<TrashCanTile> energy_trash_can_tile;
    @ObjectHolder(value="trashcans:ultimate_trash_can_tile")
    public static TileEntityType<TrashCanTile> ultimate_trash_can_tile;
    @ObjectHolder(value="trashcans:item_trash_can_container")
    public static ContainerType<ItemTrashCanContainer> item_trash_can_container;
    @ObjectHolder(value="trashcans:liquid_trash_can_container")
    public static ContainerType<LiquidTrashCanContainer> liquid_trash_can_container;
    @ObjectHolder(value="trashcans:energy_trash_can_container")
    public static ContainerType<EnergyTrashCanContainer> energy_trash_can_container;
    @ObjectHolder(value="trashcans:ultimate_trash_can_container")
    public static ContainerType<UltimateTrashCanContainer> ultimate_trash_can_container;

    public TrashCans() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        CHANNEL.registerMessage(0, PacketToggleItemWhitelist.class, TrashCanPacket::encode, PacketToggleItemWhitelist::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(1, PacketToggleLiquidWhitelist.class, TrashCanPacket::encode, PacketToggleLiquidWhitelist::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(2, PacketToggleEnergyLimit.class, TrashCanPacket::encode, PacketToggleEnergyLimit::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(3, PacketChangeEnergyLimit.class, PacketChangeEnergyLimit::encode, PacketChangeEnergyLimit::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(4, PacketChangeItemFilter.class, PacketChangeItemFilter::encode, PacketChangeItemFilter::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(5, PacketChangeLiquidFilter.class, PacketChangeLiquidFilter::encode, PacketChangeLiquidFilter::decode, TrashCanPacket::handle);
    }

    public void init(FMLCommonSetupEvent e) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::registerScreen);
        LiquidTrashCanFilters.register(new FluidFilterManager(), "fluid");
        Compatibility.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("item_trash_can", () -> new TrashCanTile(item_trash_can_tile, true, false, false), ItemTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("liquid_trash_can", () -> new TrashCanTile(liquid_trash_can_tile, false, true, false), LiquidTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("energy_trash_can", () -> new TrashCanTile(energy_trash_can_tile, false, false, true), EnergyTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("ultimate_trash_can", () -> new TrashCanTile(ultimate_trash_can_tile, true, true, true), UltimateTrashCanContainer::new));
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> e) {
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new TrashCanTile(item_trash_can_tile, true, false, false), (Block[])new Block[]{item_trash_can}).func_206865_a(null).setRegistryName("item_trash_can_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new TrashCanTile(liquid_trash_can_tile, false, true, false), (Block[])new Block[]{liquid_trash_can}).func_206865_a(null).setRegistryName("liquid_trash_can_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new TrashCanTile(energy_trash_can_tile, false, false, true), (Block[])new Block[]{energy_trash_can}).func_206865_a(null).setRegistryName("energy_trash_can_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new TrashCanTile(ultimate_trash_can_tile, true, true, true), (Block[])new Block[]{ultimate_trash_can}).func_206865_a(null).setRegistryName("ultimate_trash_can_tile"));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            e.getRegistry().register(new BlockItem(item_trash_can, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("item_trash_can"));
            e.getRegistry().register(new BlockItem(liquid_trash_can, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("liquid_trash_can"));
            e.getRegistry().register(new BlockItem(energy_trash_can, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("energy_trash_can"));
            e.getRegistry().register(new BlockItem(ultimate_trash_can, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("ultimate_trash_can"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> e) {
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new ItemTrashCanContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("item_trash_can_container"));
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new LiquidTrashCanContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("liquid_trash_can_container"));
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new EnergyTrashCanContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("energy_trash_can_container"));
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new UltimateTrashCanContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("ultimate_trash_can_container"));
        }

        @SubscribeEvent
        public static void onGatherData(GatherDataEvent e) {
            e.getGenerator().func_200390_a((IDataProvider)new TrashCansAdvancementProvider(e));
        }
    }
}

