/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TrashCanTile
extends BaseTileEntity
implements ITickableTileEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final IItemHandler ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ItemStack filter : TrashCanTile.this.itemFilter) {
                if (filter.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanTile.this.itemFilterWhitelist ? ItemStack.field_190927_a : stack;
            }
            return TrashCanTile.this.itemFilterWhitelist ? stack : ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (ItemStack filter : TrashCanTile.this.itemFilter) {
                if (filter.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanTile.this.itemFilterWhitelist;
            }
            return !TrashCanTile.this.itemFilterWhitelist;
        }
    };
    public final IFluidHandler FLUID_HANDLER = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            for (ItemFilter filter : TrashCanTile.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                return TrashCanTile.this.liquidFilterWhitelist;
            }
            return !TrashCanTile.this.liquidFilterWhitelist;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (ItemFilter filter : TrashCanTile.this.liquidFilter) {
                if (filter == null || !filter.matches(resource)) continue;
                return TrashCanTile.this.liquidFilterWhitelist ? resource.getAmount() : 0;
            }
            return TrashCanTile.this.liquidFilterWhitelist ? 0 : resource.getAmount();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public final IItemHandler LIQUID_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanTile.this.liquidItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanTile.this.liquidItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanTile.this.liquidItem.func_190926_b() || stack.func_190926_b()) {
                return stack;
            }
            if (!simulate) {
                TrashCanTile.this.liquidItem = stack.func_77946_l();
                TrashCanTile.this.liquidItem.func_190920_e(1);
                TrashCanTile.this.dataChanged();
            }
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190918_g(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanTile.this.liquidItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = TrashCanTile.this.liquidItem.func_77946_l();
            stack.func_190920_e(Math.min(amount, stack.func_190916_E()));
            if (!simulate) {
                TrashCanTile.this.liquidItem.func_190918_g(amount);
                TrashCanTile.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            boolean filtered = !TrashCanTile.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanTile.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanTile.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).filter(handler -> {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty()) continue;
                    return true;
                }
                return false;
            }).isPresent() || Compatibility.MEKANISM.doesItemHaveGasStored(stack);
        }
    };
    public final IEnergyStorage ENERGY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TrashCanTile.this.useEnergyLimit ? Math.min(maxReceive, TrashCanTile.this.energyLimit) : maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    public final IItemHandler ENERGY_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanTile.this.energyItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanTile.this.energyItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanTile.this.energyItem.func_190926_b() || stack.func_190926_b()) {
                return stack;
            }
            if (!simulate) {
                TrashCanTile.this.energyItem = stack.func_77946_l();
                TrashCanTile.this.energyItem.func_190920_e(1);
                TrashCanTile.this.dataChanged();
            }
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190918_g(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanTile.this.energyItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = TrashCanTile.this.energyItem.func_77946_l();
            stack.func_190920_e(Math.min(amount, stack.func_190916_E()));
            if (!simulate) {
                TrashCanTile.this.energyItem.func_190918_g(amount);
                TrashCanTile.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getCapability(CapabilityEnergy.ENERGY).filter(storage -> storage.canExtract() && storage.getEnergyStored() > 0).isPresent();
        }
    };
    public final boolean items;
    public final ArrayList<ItemStack> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public ItemStack liquidItem = ItemStack.field_190927_a;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public ItemStack energyItem = ItemStack.field_190927_a;

    public TrashCanTile(TileEntityType<?> tileEntityTypeIn, boolean items, boolean liquids, boolean energy) {
        super(tileEntityTypeIn);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(ItemStack.field_190927_a);
            this.liquidFilter.add(null);
        }
    }

    public void func_73660_a() {
        if (this.liquids && !this.liquidItem.func_190926_b() && this.liquidItem.func_77973_b() != Items.field_151133_ar) {
            this.liquidItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
                boolean changed = false;
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    if (fluidHandler.getFluidInTank(tank).isEmpty()) continue;
                    fluidHandler.drain(fluidHandler.getFluidInTank(tank), IFluidHandler.FluidAction.EXECUTE);
                    changed = true;
                }
                if (changed) {
                    this.liquidItem = fluidHandler.getContainer();
                    this.dataChanged();
                }
            });
            if (Compatibility.MEKANISM.drainGasFromItem(this.liquidItem)) {
                this.dataChanged();
            }
        }
        if (this.energy && !this.energyItem.func_190926_b()) {
            this.energyItem.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
                this.dataChanged();
            });
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.items && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.ITEM_HANDLER).cast();
        }
        if (this.liquids) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return LazyOptional.of(() -> this.FLUID_HANDLER).cast();
            }
            if (Compatibility.MEKANISM.isInstalled() && cap == Compatibility.MEKANISM.getGasHandlerCapability()) {
                Object handler = Compatibility.MEKANISM.getGasHandler(this.liquidFilter, () -> this.liquidFilterWhitelist);
                return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> handler).cast();
            }
        }
        if (this.energy && cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.ENERGY_STORAGE).cast();
        }
        return LazyOptional.empty();
    }

    protected CompoundNBT writeData() {
        int i;
        CompoundNBT tag = new CompoundNBT();
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                tag.func_218657_a("itemFilter" + i, (INBT)this.itemFilter.get(i).func_77955_b(new CompoundNBT()));
            }
            tag.func_74757_a("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                tag.func_218657_a("liquidFilter" + i, (INBT)LiquidTrashCanFilters.write(this.liquidFilter.get(i)));
            }
            tag.func_74757_a("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.func_190926_b()) {
                tag.func_218657_a("liquidItem", (INBT)this.liquidItem.func_77955_b(new CompoundNBT()));
            }
        }
        if (this.energy) {
            tag.func_74757_a("useEnergyLimit", this.useEnergyLimit);
            tag.func_74768_a("energyLimit", this.energyLimit);
            if (!this.energyItem.func_190926_b()) {
                tag.func_218657_a("energyItem", (INBT)this.energyItem.func_77955_b(new CompoundNBT()));
            }
        }
        return tag;
    }

    protected void readData(CompoundNBT tag) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, tag.func_74764_b("itemFilter" + i) ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("itemFilter" + i)) : ItemStack.field_190927_a);
            }
            boolean bl = this.itemFilterWhitelist = tag.func_74764_b("itemFilterWhitelist") && tag.func_74767_n("itemFilterWhitelist");
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, tag.func_74764_b("liquidFilter" + i) ? LiquidTrashCanFilters.read(tag.func_74775_l("liquidFilter" + i)) : null);
            }
            this.liquidFilterWhitelist = tag.func_74764_b("liquidFilterWhitelist") && tag.func_74767_n("liquidFilterWhitelist");
            ItemStack itemStack = this.liquidItem = tag.func_74764_b("liquidItem") ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("liquidItem")) : ItemStack.field_190927_a;
        }
        if (this.energy) {
            this.useEnergyLimit = tag.func_74764_b("useEnergyLimit") && tag.func_74767_n("useEnergyLimit");
            this.energyLimit = tag.func_74764_b("energyLimit") ? tag.func_74762_e("energyLimit") : 10000;
            this.energyItem = tag.func_74764_b("energyItem") ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("energyItem")) : ItemStack.field_190927_a;
        }
    }
}

