/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateInstance;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.model.baked.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.BaseSmartModel;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.ModelCombined;
import mod.chiselsandbits.render.NullBakedModel;
import mod.chiselsandbits.render.cache.CacheMap;
import mod.chiselsandbits.render.chiseledblock.ChiselRenderType;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBakedModel;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class ChiseledBlockSmartModel
extends BaseSmartModel
implements ICacheClearable {
    private static final SimpleMaxSizedCache<ModelCacheKey, ChiseledBlockBakedModel> MODEL_CACHE = new SimpleMaxSizedCache((Long)ChiselsAndBits.getConfig().getClient().modelCacheSize.get());
    private static final CacheMap<ItemStack, IBakedModel> ITEM_TO_MODEL_CACHE = new CacheMap();
    private static final CacheMap<VoxelBlobStateInstance, Integer> SIDE_CACHE = new CacheMap();
    public static final BitSet FLUID_RENDER_TYPES = new BitSet(RenderType.func_228661_n_().size());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSides(TileEntityBlockChiseled te) {
        Integer out;
        VoxelBlobStateReference ref = te.getBlobStateReference();
        if (ref == null) {
            return 0;
        }
        CacheMap<VoxelBlobStateInstance, Integer> cacheMap = SIDE_CACHE;
        synchronized (cacheMap) {
            out = SIDE_CACHE.get(ref.getInstance());
            if (out == null) {
                VoxelBlob blob = ref.getVoxelBlob();
                blob.filter(RenderType.func_228639_c_());
                blob.filterFluids(false);
                out = blob.getSideFlags(0, 15, 256);
                SIDE_CACHE.put(ref.getInstance(), out);
            }
        }
        return out;
    }

    public static ChiseledBlockBakedModel getCachedModel(TileEntityBlockChiseled te, ChiselRenderType layer) {
        VoxelBlobStateReference data = te.getBlobStateReference();
        Integer blockP = te.getPrimaryBlockStateId();
        VoxelBlob vBlob = data != null ? data.getVoxelBlob() : null;
        return ChiseledBlockSmartModel.getCachedModel(blockP, vBlob, layer, ChiseledBlockSmartModel.getModelFormat(), Objects.requireNonNull(te.func_145831_w()).field_73012_v);
    }

    public static ChiseledBlockBakedModel getCachedModel(ItemStack stack, ChiselRenderType layer) {
        Integer blockP = 0;
        return ChiseledBlockSmartModel.getCachedModel(blockP, ModUtil.getBlobFromStack(stack, null), layer, ChiseledBlockSmartModel.getModelFormat(), new Random());
    }

    private static VertexFormat getModelFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    public static boolean ForgePipelineDisabled() {
        return (Boolean)ForgeConfig.CLIENT.forgeLightPipelineEnabled.get() == false || (Boolean)ChiselsAndBits.getConfig().getClient().disableCustomVertexFormats.get() != false;
    }

    public static ChiseledBlockBakedModel getCachedModel(Integer blockP, VoxelBlob data, ChiselRenderType layer, VertexFormat format, Random random) {
        if (data == null) {
            return new ChiseledBlockBakedModel(blockP, layer, null, format);
        }
        ChiseledBlockBakedModel out = null;
        if (format == ChiseledBlockSmartModel.getModelFormat()) {
            out = MODEL_CACHE.get(new ModelCacheKey(data, layer));
        }
        if (out == null) {
            out = new ChiseledBlockBakedModel(blockP, layer, data, format);
            if (out.isEmpty()) {
                out = ChiseledBlockBakedModel.breakingParticleModel(layer, blockP, random);
            }
            if (format == ChiseledBlockSmartModel.getModelFormat()) {
                MODEL_CACHE.put(new ModelCacheKey(data, layer), out);
            }
        } else {
            return out;
        }
        return out;
    }

    @Override
    public IBakedModel handleBlockState(BlockState state, Random rand, IModelData modelData) {
        BaseBakedBlockModel baked;
        if (state == null) {
            return NullBakedModel.instance;
        }
        VoxelBlobStateReference data = (VoxelBlobStateReference)modelData.getData(TileEntityBlockChiseled.MP_VBSR);
        VoxelBlob blob = data == null ? null : data.getVoxelBlob();
        Integer blockP = (Integer)modelData.getData(TileEntityBlockChiseled.MP_PBSI);
        blockP = blockP == null ? 0 : blockP;
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            IBakedModel[] models = new ChiseledBlockBakedModel[ChiselRenderType.values().length];
            int o = 0;
            for (ChiselRenderType l : ChiselRenderType.values()) {
                models[o++] = ChiseledBlockSmartModel.getCachedModel(blockP, blob, l, ChiseledBlockSmartModel.getModelFormat(), rand);
            }
            return new ModelCombined(models);
        }
        if (RenderType.func_228661_n_().contains(layer) && FLUID_RENDER_TYPES.get(RenderType.func_228661_n_().indexOf(layer))) {
            ChiseledBlockBakedModel a = ChiseledBlockSmartModel.getCachedModel(blockP, blob, ChiselRenderType.fromLayer(layer, false), ChiseledBlockSmartModel.getModelFormat(), rand);
            ChiseledBlockBakedModel b = ChiseledBlockSmartModel.getCachedModel(blockP, blob, ChiselRenderType.fromLayer(layer, true), ChiseledBlockSmartModel.getModelFormat(), rand);
            baked = a.isEmpty() ? b : (b.isEmpty() ? a : new ModelCombined(a, b));
        } else {
            baked = ChiseledBlockSmartModel.getCachedModel(blockP, blob, ChiselRenderType.fromLayer(layer, false), ChiseledBlockSmartModel.getModelFormat(), rand);
        }
        return baked;
    }

    @Override
    public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, World world, LivingEntity entity) {
        IBakedModel mdl = ITEM_TO_MODEL_CACHE.get(stack);
        if (mdl != null) {
            return mdl;
        }
        CompoundNBT c = stack.func_77978_p();
        if (c == null) {
            return this;
        }
        c = c.func_74775_l("BlockEntityTag");
        byte[] data = c.func_74770_j("v");
        byte[] vdata = c.func_74770_j("X");
        Integer blockP = c.func_74762_e("b");
        if (vdata.length == 0 && data.length > 0) {
            VoxelBlob xx = new VoxelBlob();
            try {
                xx.fromLegacyByteArray(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            vdata = xx.blobToBytes(3);
        }
        IBakedModel[] models = new IBakedModel[ChiselRenderType.values().length];
        for (ChiselRenderType l : ChiselRenderType.values()) {
            models[l.ordinal()] = ChiseledBlockSmartModel.getCachedModel(blockP, new VoxelBlobStateReference(vdata, 0L).getVoxelBlob(), l, DefaultVertexFormats.field_176600_a, new Random());
        }
        mdl = new ModelCombined(models);
        ITEM_TO_MODEL_CACHE.put(stack, mdl);
        return mdl;
    }

    @Override
    public void clearCache() {
        SIDE_CACHE.clear();
        MODEL_CACHE.clear();
        ITEM_TO_MODEL_CACHE.clear();
        FLUID_RENDER_TYPES.clear();
        List blockRenderTypes = RenderType.func_228661_n_();
        block0: for (int i = 0; i < blockRenderTypes.size(); ++i) {
            RenderType renderType = (RenderType)blockRenderTypes.get(i);
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (!RenderTypeLookup.canRenderInLayer((FluidState)fluid.func_207188_f(), (RenderType)renderType)) continue;
                FLUID_RENDER_TYPES.set(i);
                continue block0;
            }
        }
    }

    public static void onConfigurationReload(ModConfig.Reloading event) {
        MODEL_CACHE.changeMaxSize((Long)ChiselsAndBits.getConfig().getClient().modelCacheSize.get());
    }

    public boolean func_230044_c_() {
        return true;
    }

    private static final class ModelCacheKey {
        private final VoxelBlob blob;
        private final ChiselRenderType type;

        private ModelCacheKey(VoxelBlob blob, ChiselRenderType type) {
            this.blob = blob;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModelCacheKey)) {
                return false;
            }
            ModelCacheKey that = (ModelCacheKey)o;
            return Objects.equals(this.blob, that.blob) && Objects.equals((Object)this.type, (Object)that.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.blob, this.type});
        }
    }
}

